/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.TextBuilder;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ExceptionUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.TypeUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Logger;

public class ToStringBuilder {
    public static final FieldDecision DEFAULT_DECISION = new FieldDecision(){

        @Override
        protected boolean useToObjectInfo(Object value, Field member) {
            return false;
        }
    };
    private int level;
    private boolean isCompact;
    private boolean tabAsIdent;
    private FieldDecision fieldDecision = DEFAULT_DECISION;
    private int identTabs;

    public ToStringBuilder() {
        this(2);
    }

    public ToStringBuilder(int level) {
        this.setLevel(level);
    }

    public ToStringBuilder fieldDecision(FieldDecision fieldDecision) {
        this.fieldDecision = fieldDecision;
        return this;
    }

    public String toString(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs, this.isCompact);
        if (obj == null) {
            return builder.append("null").toString();
        }
        this.toStringObject(obj, 1, this.isCompact, builder);
        return builder.toString();
    }

    public String toStringFields(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs, this.isCompact);
        if (obj == null) {
            return builder.append("null").toString();
        }
        this.toStringFields(obj, 1, this.isCompact, builder);
        return builder.toString();
    }

    private void toStringObject(Object obj, int level, boolean isCompact, TextBuilder builder) {
        if (obj == null) {
            builder.append("null");
            return;
        }
        if (obj instanceof Iterable) {
            this.toStringIterator(obj, new IteratorIterator(((Iterable)obj).iterator()), level, isCompact, builder);
            return;
        }
        if (obj instanceof Iterator) {
            this.toStringIterator(obj, new IteratorIterator((Iterator)obj), level, isCompact, builder);
            return;
        }
        if (obj instanceof Enumeration) {
            this.toStringIterator(obj, new EnumerationIterator((Enumeration)obj), level, isCompact, builder);
            return;
        }
        if (obj.getClass().isArray()) {
            this.toStringIterator(obj, new ArrayIterator(obj), level, isCompact, builder);
            return;
        }
        if (obj instanceof Map) {
            this.toStringMap((Map)obj, level, isCompact, builder);
            return;
        }
        if (obj instanceof Throwable) {
            builder.append(ExceptionUtils.toStackTrace((Throwable)obj));
            return;
        }
        if (obj.getClass() == String.class) {
            builder.append("\"").append(obj).append("\"").append(" (").append(((String)obj).length()).append(")");
            return;
        }
        if (TypeUtils.isPrimOrWrapperType(obj.getClass())) {
            builder.append(obj);
            return;
        }
        if (this.useToString(obj.getClass(), level)) {
            builder.append(obj);
        } else {
            this.toStringFields(obj, level, isCompact, builder);
        }
    }

    private void toStringFields(Object obj, int level, boolean isCompact, TextBuilder builder) {
        builder.append(ObjectUtils.toObjectInfo(obj));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!isFirst) {
                    builder.append(",");
                } else {
                    isFirst = false;
                }
                this.appendln(builder, isCompact);
                this.appendtab(builder, level + this.identTabs, isCompact);
                builder.append(field.getName()).append(": ");
                try {
                    field.setAccessible(true);
                    Object fieldVal = field.get(obj);
                    if (fieldVal == null) {
                        builder.append("null");
                        continue;
                    }
                    if (this.fieldDecision.isToObjectInfo(fieldVal, field)) {
                        ToStringBuilder.toObjectInfo(builder, fieldVal, field);
                        continue;
                    }
                    boolean compact = this.isFieldCompact(fieldVal, field, isCompact);
                    this.toStringObject(fieldVal, level + 1, compact, builder);
                }
                catch (Throwable ex) {
                    builder.append("error=").append(ExceptionUtils.buildMessage(ex));
                }
            }
        }
        if (isFirst) {
            builder.append(" no fields ]");
        } else {
            this.appendln(builder, isCompact);
            this.appendtab(builder, level - 1 + this.identTabs, isCompact).append("]");
        }
    }

    private void toStringIterator(Object obj, ElementIterator iterator, int level, boolean isCompact, TextBuilder builder) {
        builder.append(ObjectUtils.toObjectInfo(obj));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder, isCompact);
            this.appendtab(builder, level + this.identTabs, isCompact);
            if (element == null) {
                builder.append("null");
                continue;
            }
            if (this.fieldDecision.isToObjectInfo(element, null)) {
                builder.append(ObjectUtils.toObjectInfo(element));
                continue;
            }
            this.toStringObject(element, level + 1, isCompact, builder);
        }
        if (isFirst) {
            builder.append(" no elements ]");
        } else {
            this.appendln(builder, isCompact);
            this.appendtab(builder, level - 1 + this.identTabs, isCompact).append("] (").append(iterator.getIndex()).append(")");
        }
    }

    private void toStringMap(Map<?, ?> map, int level, boolean isCompact, TextBuilder builder) {
        builder.append(ObjectUtils.toObjectInfo(map));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        for (Object key : map.keySet()) {
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder, isCompact);
            this.appendtab(builder, level + this.identTabs, isCompact);
            builder.append(key).append(": ");
            Object entryVal = map.get(key);
            if (entryVal == null) {
                builder.append("null");
                continue;
            }
            if (this.fieldDecision.isToObjectInfo(entryVal, null)) {
                builder.append(ObjectUtils.toObjectInfo(entryVal));
                continue;
            }
            this.toStringObject(entryVal, level + 1, isCompact, builder);
        }
        if (isFirst) {
            builder.append(" no entries ]");
        } else {
            this.appendln(builder, isCompact);
            this.appendtab(builder, level - 1 + this.identTabs, isCompact).append("] (").append(map.size()).append(")");
        }
    }

    private void toStringAttributes(Object obj, Method getAttributeMethod, Set<String> attributes, int level, boolean isCompact, TextBuilder builder) {
        builder.append("[");
        boolean isFirst = true;
        for (String attribute : attributes) {
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder, isCompact);
            this.appendtab(builder, level + this.identTabs, isCompact);
            builder.append(attribute).append(": ");
            try {
                Object element = getAttributeMethod.invoke(obj, attribute);
                if (element == null) {
                    builder.append("null");
                    continue;
                }
                if ("javax.servlet.error.exception".equals(attribute)) {
                    builder.append(ObjectUtils.toObjectInfo(element));
                    continue;
                }
                if (this.fieldDecision.isToObjectInfo(element, null)) {
                    builder.append(ObjectUtils.toObjectInfo(element));
                    continue;
                }
                this.toStringObject(element, level + 1, isCompact, builder);
            }
            catch (Throwable ex) {
                builder.append("error=").append(ExceptionUtils.buildMessage(ex));
            }
        }
        if (isFirst) {
            builder.append(" no elements ]");
        } else {
            this.appendln(builder, isCompact);
            this.appendtab(builder, level - 1 + this.identTabs, isCompact).append("]");
        }
    }

    public String toStringAttributes(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs, this.isCompact);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        try {
            Set<String> attributes = ToStringBuilder.getAttributeNames(obj, "getAttributeNames");
            Method method = ReflectionUtils.findMethod(obj.getClass(), "getAttribute");
            AssertUtils.assertNotNull(method);
            builder.append(ObjectUtils.toObjectInfo(obj)).append("-attributes");
            this.toStringAttributes(obj, method, attributes, 1, this.isCompact, builder);
        }
        catch (Throwable ex) {
            builder.append("error=").append(ExceptionUtils.buildMessage(ex));
        }
        return builder.toString();
    }

    public String toStringHeaders(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs, this.isCompact);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        try {
            Set<String> attributes = ToStringBuilder.getAttributeNames(obj, "getHeaderNames");
            Method method = ReflectionUtils.findMethod(obj.getClass(), "getHeaders");
            AssertUtils.assertNotNull(method);
            builder.append(ObjectUtils.toObjectInfo(obj)).append("-headers");
            this.toStringAttributes(obj, method, attributes, 1, this.isCompact, builder);
        }
        catch (Throwable ex) {
            builder.append("error=").append(ExceptionUtils.buildMessage(ex));
        }
        return builder.toString();
    }

    private static Set<String> getAttributeNames(Object obj, String methodName) throws Exception {
        Method method = ReflectionUtils.findMethod(obj.getClass(), methodName);
        AssertUtils.assertNotNull(method);
        Object attrs = method.invoke(obj, new Object[0]);
        TreeSet<String> names = new TreeSet<String>();
        if (attrs instanceof Enumeration) {
            Enumeration enm = (Enumeration)ObjectUtils.cast(attrs);
            while (enm.hasMoreElements()) {
                names.add((String)enm.nextElement());
            }
        } else {
            Collection attrCol = (Collection)ObjectUtils.cast(attrs);
            names.addAll(attrCol);
        }
        return names;
    }

    public ToStringBuilder setLevel(int level) {
        this.level = Math.max(level, 1);
        return this;
    }

    public ToStringBuilder useCompact() {
        this.isCompact = true;
        return this;
    }

    public ToStringBuilder useTabAsIdent() {
        this.tabAsIdent = true;
        return this;
    }

    public ToStringBuilder setIdentTabs(int identTabs) {
        this.identTabs = Math.max(identTabs, 0);
        return this;
    }

    private TextBuilder appendln(TextBuilder builder, boolean isCompact) {
        if (!isCompact) {
            builder.appendln();
        }
        return builder;
    }

    private TextBuilder appendtab(TextBuilder builder, int tabs, boolean isCompact) {
        if (isCompact) {
            builder.appendsp();
        } else if (this.tabAsIdent) {
            builder.appendtab(tabs);
        } else {
            builder.append4sp(tabs);
        }
        return builder;
    }

    protected boolean useToString(Class<?> type, int level) {
        if (level == 1) {
            return false;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || TimeZone.class.isAssignableFrom(type) || type == Locale.class) {
            return true;
        }
        if (type.getPackage().getName().equals("java.time")) {
            return true;
        }
        if (type == File.class || type.getName().equals("java.nio.file.Path") || type == URL.class || type == URI.class) {
            return true;
        }
        if (AnnotatedElement.class.isAssignableFrom(type) || Type.class.isAssignableFrom(type) || ClassLoader.class.isAssignableFrom(type)) {
            return true;
        }
        if (InputStream.class.isAssignableFrom(type) || OutputStream.class.isAssignableFrom(type)) {
            return true;
        }
        if (Reader.class.isAssignableFrom(type) || Writer.class.isAssignableFrom(type)) {
            return true;
        }
        return ResourceBundle.class.isAssignableFrom(type) || Logger.class.isAssignableFrom(type);
    }

    protected boolean isFieldCompact(Object fieldVal, Field field, boolean isCompact) {
        Class<?> elementType;
        if (isCompact || field.getAnnotation(Compact.class) != null) {
            return true;
        }
        return field.getType().isArray() && ((elementType = field.getType().getComponentType()) == String.class || TypeUtils.isPrimOrWrapperType(elementType) || elementType == BigDecimal.class) && Array.getLength(fieldVal) <= 512;
    }

    static void toObjectInfo(TextBuilder builder, Object fieldVal, Field member) {
        builder.append(member.getType().getName());
        if (!member.getType().isPrimitive()) {
            builder.append("@").append(Integer.toHexString(fieldVal.hashCode()));
        }
    }

    static class EnumerationIterator
    implements ElementIterator {
        final Enumeration<?> obj;
        int index = 0;

        public EnumerationIterator(Enumeration<?> obj) {
            this.obj = obj;
        }

        @Override
        public boolean hasNext() {
            return this.obj.hasMoreElements();
        }

        @Override
        public Object next() {
            ++this.index;
            return this.obj.nextElement();
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class IteratorIterator
    implements ElementIterator {
        final Iterator<?> obj;
        int index = 0;

        public IteratorIterator(Iterator<?> obj) {
            this.obj = obj;
        }

        @Override
        public boolean hasNext() {
            return this.obj.hasNext();
        }

        @Override
        public Object next() {
            ++this.index;
            return this.obj.next();
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class ArrayIterator
    implements ElementIterator {
        final Object obj;
        final int len;
        int index = 0;

        public ArrayIterator(Object obj) {
            this.obj = obj;
            this.len = Array.getLength(obj);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public Object next() {
            return Array.get(this.obj, this.index++);
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static interface ElementIterator {
        public boolean hasNext();

        public Object next();

        public int getIndex();
    }

    public static abstract class FieldDecision {
        static boolean isJdkClass(Class<?> type) {
            return type.getName().startsWith("java.") || type.getName().startsWith("javax.") || type.getName().startsWith("sun.") || type.getName().startsWith("com.sun.") || type.getName().startsWith("com.oracle.") || type.getName().startsWith("jdk.") || type.getName().startsWith("org.omg.") || type.getName().startsWith("org.w3c.");
        }

        public boolean isToObjectInfo(Object value, Field member) {
            if (member != null && member.getAnnotation(ToObjectInfo.class) != null) {
                return true;
            }
            if (!FieldDecision.isJdkClass(value.getClass()) && ReflectionUtils.findAnnotation(value.getClass(), ToObjectInfo.class) != null) {
                return true;
            }
            return this.useToObjectInfo(value, member);
        }

        protected abstract boolean useToObjectInfo(Object var1, Field var2);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Compact {
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface ToObjectInfo {
    }
}

