/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.UncheckedInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class ThreadSafeTester
extends InitializeObject {
    private int tasks = 1000;
    private int threads = 25;
    private CountDownLatch countDownLatch;
    private ExecutorService executorService;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.tasks > 0);
        AssertUtils.assertTrue(this.threads > 0);
        this.executorService = Executors.newFixedThreadPool(this.threads);
        this.countDownLatch = new CountDownLatch(this.tasks);
    }

    public ThreadSafeTester tasks(int tasks) {
        this.assertNotInitialized();
        this.tasks = tasks;
        return this;
    }

    public ThreadSafeTester threads(int threads) {
        this.assertNotInitialized();
        this.threads = threads;
        return this;
    }

    protected abstract Runnable newTask();

    public ThreadSafeTester executeThenAwait() {
        return this.executeThenAwait(0L, null);
    }

    public ThreadSafeTester executeThenAwait(long timeout, TimeUnit unit) {
        this.initialize();
        for (int i = 0; i < this.tasks; ++i) {
            this.executorService.execute(this.newTask());
        }
        try {
            if (timeout == 0L) {
                this.countDownLatch.await();
            } else {
                this.countDownLatch.await(timeout, unit);
            }
        }
        catch (InterruptedException ex) {
            throw new UncheckedInterruptedException(ex);
        }
        this.executorService.shutdown();
        return this;
    }

    protected void countDown() {
        this.countDownLatch.countDown();
    }
}

