/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BoolFormatException;
import com.appslandia.common.base.Config;
import com.appslandia.common.base.DateFormatException;
import com.appslandia.common.base.MapWrapper;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.SplitUtils;
import com.appslandia.common.utils.StringFormatUtils;
import com.appslandia.common.utils.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConfigBase
extends MapWrapper<String, String>
implements Config {
    private static final long serialVersionUID = 1L;

    public ConfigBase() {
        super(new HashMap());
    }

    public ConfigBase(Map<String, String> newMap) {
        super(newMap);
    }

    @Override
    public String getString(String key) {
        return this.doGet(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.doGet(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getRequiredString(String key) throws NullPointerException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return value;
    }

    @Override
    public String[] getStringArray(String key) {
        String value = this.doGet(key);
        if (value == null) {
            return StringUtils.EMPTY_ARRAY;
        }
        List<String> list = SplitUtils.splitByComma(value);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getFormatted(String key) {
        String value = this.doGet(key);
        if (value == null) {
            return null;
        }
        Map m = (Map)ObjectUtils.cast(this);
        return StringFormatUtils.format(value, m);
    }

    @Override
    public String getRequiredFormatted(String key) throws NullPointerException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        Map m = (Map)ObjectUtils.cast(this);
        return StringFormatUtils.format(value, m);
    }

    @Override
    public String getFormatted(String key, Map<String, Object> parameters) {
        String value = this.doGet(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getRequiredFormatted(String key, Map<String, Object> parameters) throws NullPointerException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getFormatted(String key, Object ... parameters) {
        String value = this.doGet(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getRequiredFormatted(String key, Object ... parameters) throws NullPointerException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        String value = this.doGet(key);
        if (value == null) {
            return defaultValue;
        }
        if (ConfigBase.isTrueValue(value)) {
            return true;
        }
        if (ConfigBase.isFalseValue(value)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean getRequiredBool(String key) throws NullPointerException, BoolFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        if (ConfigBase.isTrueValue(value)) {
            return true;
        }
        if (ConfigBase.isFalseValue(value)) {
            return false;
        }
        throw new BoolFormatException(value);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.doGet(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public int getRequiredInt(String key) throws NullPointerException, NumberFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Integer.parseInt(value);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String value = this.doGet(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public long getRequiredLong(String key) throws NullPointerException, NumberFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Long.parseLong(value);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        String value = this.doGet(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public float getRequiredFloat(String key) throws NullPointerException, NumberFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Float.parseFloat(value);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        String value = this.doGet(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public double getRequiredDouble(String key) throws NullPointerException, NumberFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Double.parseDouble(value);
    }

    @Override
    public Date getDate(String key) {
        String value = this.doGet(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601Date(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Date getRequiredDate(String key) throws NullPointerException, DateFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return DateUtils.iso8601Date(value);
    }

    @Override
    public Time getTime(String key) {
        String value = this.doGet(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601Time(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Time getRequiredTime(String key) throws NullPointerException, DateFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return DateUtils.iso8601Time(value);
    }

    @Override
    public Timestamp getDateTime(String key) {
        String value = this.doGet(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601DateTime(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Timestamp getRequiredDateTime(String key) throws NullPointerException, DateFormatException {
        String value = this.doGet(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return DateUtils.iso8601DateTime(value);
    }

    protected String doGet(Object key) {
        return (String)this.map.get(key);
    }

    @Override
    public String get(Object key) {
        return this.doGet(key);
    }

    protected String doPut(String key, String value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> config : m.entrySet()) {
            this.doPut(config.getKey(), StringUtils.trimToNull(config.getValue()));
        }
    }

    @Override
    public String put(String key, String value) {
        return this.doPut(key, StringUtils.trimToNull(value));
    }

    @Override
    public void put(String key, boolean value) {
        this.doPut(key, Boolean.toString(value));
    }

    @Override
    public void put(String key, int value) {
        this.doPut(key, Integer.toString(value));
    }

    @Override
    public void put(String key, long value) {
        this.doPut(key, Long.toString(value));
    }

    @Override
    public void put(String key, float value) {
        this.doPut(key, Float.toString(value));
    }

    @Override
    public void put(String key, double value) {
        this.doPut(key, Double.toString(value));
    }

    @Override
    public void put(String key, Object value) {
        this.doPut(key, this.toStringValue(value));
    }

    protected String toStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == String.class) {
            return StringUtils.trimToNull((String)value);
        }
        if (value instanceof Date) {
            return DateUtils.iso8601Date((Date)value);
        }
        if (value instanceof Time) {
            return DateUtils.iso8601Time((Time)value);
        }
        if (value instanceof Timestamp) {
            return DateUtils.iso8601DateTime((Timestamp)value);
        }
        return value.toString();
    }

    private static boolean isTrueValue(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    private static boolean isFalseValue(String value) {
        return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no");
    }
}

