/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface Email {
    public static final Pattern EMAIL_PATTERN = Pattern.compile("[_a-z\\d-\\+]+(\\.[_a-z\\d-]+)*@[a-z\\d-]+(\\.[a-z\\d-]+)*(\\.[a-z]{2,})", 2);

    public String message() default "{com.appslandia.common.validators.Email.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<Email, CharSequence> {
        public void initialize(Email annotation) {
        }

        public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            return EMAIL_PATTERN.matcher(value).matches();
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public Email[] value();
    }
}

