/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.URLEncoding;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class URLUtils {
    public static String toQueryParams(Map<String, Object> parameterMap) {
        StringBuilder sb = new StringBuilder(parameterMap.size() * 16);
        for (Map.Entry<String, Object> param : parameterMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            URLUtils.addQueryParam(sb, param.getKey(), param.getValue());
        }
        return sb.toString();
    }

    public static void addQueryParam(StringBuilder sb, String name, Object value) {
        if (value == null) {
            sb.append(name).append('=');
            return;
        }
        if (!value.getClass().isArray()) {
            sb.append(name).append('=').append(URLEncoding.encode(value.toString()));
            return;
        }
        int len = Array.getLength(value);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append('&');
            }
            sb.append(name).append('=');
            Object subVal = Array.get(value, i);
            if (subVal == null) continue;
            sb.append(URLEncoding.encode(subVal.toString()));
        }
    }

    public static String toURL(String url, Map<String, Object> parameterMap) {
        try {
            URI oldUri = new URI(url);
            String newQuery = oldUri.getQuery();
            newQuery = newQuery == null ? URLUtils.toQueryParams(parameterMap) : newQuery + '&' + URLUtils.toQueryParams(parameterMap);
            URI newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

