/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.ArrayUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharUtils {
    private static final Pattern CHAR_RANGE_GROUP_PATTERN = Pattern.compile(".-.");

    public static char[] toCharRanges(String charRanges) {
        Matcher matcher = CHAR_RANGE_GROUP_PATTERN.matcher(charRanges);
        char[] chars = null;
        int lastEnd = 0;
        while (matcher.find()) {
            char to;
            String range = matcher.group();
            if (matcher.start() != lastEnd) {
                char[] notRange = charRanges.substring(lastEnd, matcher.start()).toCharArray();
                chars = chars == null ? notRange : ArrayUtils.append(chars, notRange);
            }
            lastEnd = matcher.end();
            char from = range.charAt(0);
            if (from > (to = range.charAt(2))) {
                throw new IllegalArgumentException("invalid charRanges (value=" + charRanges + ")");
            }
            char[] newChars = new char[to - from + 1];
            for (int i = 0; i < newChars.length; ++i) {
                newChars[i] = (char)(from + i);
            }
            chars = chars == null ? newChars : ArrayUtils.append(chars, newChars);
        }
        if (lastEnd < charRanges.length()) {
            char[] notRange = charRanges.substring(lastEnd).toCharArray();
            chars = chars == null ? notRange : ArrayUtils.append(chars, notRange);
        }
        return chars;
    }
}

