/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.threading;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class ConcurrentService
extends InitializeObject {
    protected final Map<Object, Object> barriers = new HashMap<Object, Object>();
    protected final Object defaultMutex = new Object();

    public abstract ExecutorService getExecutorService();

    protected Object getMutex(Object barrierId) {
        Object mutex = this.barriers.get(barrierId);
        return mutex != null ? mutex : this.defaultMutex;
    }

    public <V> V execute(Object barrierId, Callable<V> task) throws Exception {
        return this.execute(barrierId, task, 0L, null);
    }

    public <V> V execute(final Object barrierId, final Callable<V> task, long timeout, TimeUnit unit) throws Exception {
        this.initialize();
        AssertUtils.assertNotNull(barrierId);
        Future result = this.getExecutorService().submit(new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                Object object = ConcurrentService.this.getMutex(barrierId);
                synchronized (object) {
                    return task.call();
                }
            }
        });
        if (timeout <= 0L) {
            return (V)result.get();
        }
        return (V)result.get(timeout, unit);
    }

    public ConcurrentService addBarrier(Object barrierId) {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(barrierId);
        this.barriers.put(barrierId, new Object());
        return this;
    }
}

