/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.objects.AnnotationUtils;
import com.appslandia.common.objects.InstanceImpl;
import com.appslandia.common.objects.ObjectDefinition;
import com.appslandia.common.objects.ObjectException;
import com.appslandia.common.objects.ObjectFactoryUtils;
import com.appslandia.common.objects.ObjectInstance;
import com.appslandia.common.objects.ObjectProducer;
import com.appslandia.common.objects.ObjectScope;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

public class ObjectFactory
extends InitializeObject {
    final List<ObjectInstance> instances = new ArrayList<ObjectInstance>();

    @Override
    protected void init() throws Exception {
        this.validateFactory();
    }

    private void validateFactory() throws ObjectException {
        for (ObjectInstance inst : this.instances) {
            if (inst.definition.getProducer() != null) continue;
            new InjectTraverser(){

                @Override
                public boolean isValidationContext() {
                    return true;
                }

                @Override
                public void onParameter(Parameter parameter) throws ObjectException {
                    this.validateInject(parameter.getType(), AnnotationUtils.parseQualifiers(parameter), parameter);
                }

                @Override
                public void onField(Field field) throws ObjectException {
                    this.validateInject(field.getType(), AnnotationUtils.parseQualifiers(field), field);
                }

                @Override
                public void onMethod(Method method) throws ObjectException {
                    throw new UnsupportedOperationException();
                }

                private String toMemberInfo(AnnotatedElement member) {
                    if (member instanceof Parameter) {
                        return ((Parameter)member).getDeclaringExecutable().toString();
                    }
                    return member.toString();
                }

                private void validateInject(Class<?> type, Annotation[] qualifiers, AnnotatedElement member) throws ObjectException {
                    if (ObjectFactory.class.isAssignableFrom(type)) {
                        return;
                    }
                    if (type == Instance.class) {
                        return;
                    }
                    int count = ObjectFactory.this.countMatchesForInject(type, qualifiers);
                    if (count == 0) {
                        throw new ObjectException("Unsatisfied dependency (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers) + ", member=" + this.toMemberInfo(member) + ")");
                    }
                    if (count > 1) {
                        throw new ObjectException("Ambiguous dependency (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers) + ", member=" + this.toMemberInfo(member) + ")");
                    }
                }
            }.traverse(inst.definition.getImplClass());
        }
    }

    private int countMatchesForInject(Class<?> type, Annotation[] qualifiers) {
        int count = 0;
        for (ObjectInstance inst : this.instances) {
            if (type != inst.definition.getType() && type != Object.class || !AnnotationUtils.equals(inst.definition.getQualifiers(), qualifiers)) continue;
            ++count;
        }
        return count;
    }

    public <T> ObjectFactory register(Class<T> type, Annotation[] qualifiers, ObjectProducer<T> producer) {
        return this.register(type, qualifiers, ObjectScope.SINGLETON, producer);
    }

    public <T> ObjectFactory register(Class<T> type, Annotation[] qualifiers, ObjectScope scope, ObjectProducer<T> producer) {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(type);
        AssertUtils.assertNotNull(scope);
        AssertUtils.assertNotNull(producer);
        ObjectInstance inst = new ObjectInstance(new ObjectDefinition().setType(type).setQualifiers(qualifiers).setScope(scope).setProducer(producer));
        this.instances.add(inst);
        return this;
    }

    public <T> ObjectFactory register(Class<T> type, Class<? extends T> implClass) {
        AssertUtils.assertNotNull(implClass);
        return this.register(type, AnnotationUtils.parseQualifiers(implClass), ObjectScope.SINGLETON, implClass);
    }

    public <T> ObjectFactory register(Class<T> type, ObjectScope scope, Class<? extends T> implClass) {
        AssertUtils.assertNotNull(implClass);
        return this.register(type, AnnotationUtils.parseQualifiers(implClass), scope, implClass);
    }

    public <T> ObjectFactory register(Class<T> type, Annotation[] qualifiers, ObjectScope scope, Class<? extends T> implClass) {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(type);
        AssertUtils.assertNotNull(scope);
        AssertUtils.assertNotNull(implClass);
        ObjectInstance inst = new ObjectInstance(new ObjectDefinition().setType(type).setQualifiers(qualifiers).setScope(scope).setImplClass(implClass));
        this.instances.add(inst);
        return this;
    }

    public ObjectFactory unregister(Class<?> type) {
        return this.unregister(type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public ObjectFactory unregister(Class<?> type, Annotation ... qualifiers) {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(type);
        AssertUtils.assertNotNull(qualifiers);
        Iterator<ObjectInstance> iter = this.instances.iterator();
        while (iter.hasNext()) {
            ObjectInstance inst = iter.next();
            if (type != inst.definition.getType() && type != Object.class || !AnnotationUtils.equals(inst.definition.getQualifiers(), qualifiers)) continue;
            iter.remove();
        }
        return this;
    }

    public <T> ObjectFactory unregister(Class<T> type, Class<? extends T> implClass) {
        AssertUtils.assertNotNull(implClass);
        return this.unregister(type, AnnotationUtils.parseQualifiers(implClass));
    }

    public ObjectFactory inject(final Object obj) throws ObjectException {
        this.initialize();
        AssertUtils.assertNotNull(obj);
        new InjectTraverser(){

            @Override
            public boolean isValidationContext() {
                return false;
            }

            @Override
            public void onParameter(Parameter parameter) throws ObjectException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onField(Field field) throws ObjectException {
                try {
                    field.setAccessible(true);
                    Annotation[] qualifiers = AnnotationUtils.parseQualifiers(field);
                    if (field.getType() != Instance.class) {
                        Object value = ObjectFactory.this.getObject(field.getType(), qualifiers);
                        field.set(obj, value);
                        return;
                    }
                    AssertUtils.assertTrue(field.getGenericType() instanceof ParameterizedType);
                    Type argType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    AssertUtils.assertTrue(argType instanceof Class);
                    Class type = (Class)argType;
                    ArrayList<ObjectInstance> insts = new ArrayList<ObjectInstance>();
                    for (ObjectInstance inst : ObjectFactory.this.instances) {
                        if (type != inst.definition.getType() && type != Object.class || !AnnotationUtils.hasAnnotations(inst.definition.getQualifiers(), qualifiers)) continue;
                        insts.add(new ObjectInstance(inst.definition).setInstance(ObjectFactory.this.produceObject(inst)));
                    }
                    field.set(obj, new InstanceImpl(type, qualifiers, insts));
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
            }

            @Override
            public void onMethod(Method method) throws ObjectException {
                try {
                    method.setAccessible(true);
                    method.invoke(obj, ObjectFactory.this.createArguments(method.getParameters()));
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
            }
        }.traverse(obj.getClass());
        return this;
    }

    private Object[] createArguments(Parameter[] parameters) throws ObjectException {
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            args[i] = this.getObject(parameter.getType(), AnnotationUtils.parseQualifiers(parameter));
        }
        return args;
    }

    private Object produceObject(ObjectInstance inst) throws ObjectException {
        try {
            if (inst.definition.getProducer() != null) {
                return inst.definition.getProducer().produce(this);
            }
            Constructor<?> emptyCtor = null;
            Constructor<?> injectCtor = null;
            for (Constructor<?> ctor : inst.definition.getImplClass().getDeclaredConstructors()) {
                if (ctor.getDeclaredAnnotation(Inject.class) != null) {
                    injectCtor = ctor;
                    break;
                }
                if (ctor.getParameterCount() != 0) continue;
                emptyCtor = ctor;
            }
            if (injectCtor == null && emptyCtor == null) {
                throw new ObjectException("Could not instantiate (implClass=" + inst.definition.getImplClass() + ")");
            }
            Object instance = null;
            if (injectCtor != null) {
                injectCtor.setAccessible(true);
                instance = injectCtor.newInstance(this.createArguments(injectCtor.getParameters()));
            } else {
                emptyCtor.setAccessible(true);
                instance = emptyCtor.newInstance(ReflectionUtils.EMPTY_OBJECTS);
            }
            return this.inject(instance).postConstruct(instance);
        }
        catch (ObjectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ObjectException(ex);
        }
    }

    private ObjectInstance getObjectInst(Class<?> type, Annotation[] qualifiers) throws ObjectException {
        ObjectInstance obj = null;
        for (ObjectInstance inst : this.instances) {
            if (type != inst.definition.getType() && type != Object.class || !AnnotationUtils.equals(inst.definition.getQualifiers(), qualifiers)) continue;
            if (obj != null) {
                throw new ObjectException("Ambiguous dependency (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers));
            }
            obj = inst;
        }
        return obj;
    }

    public <T, I extends T> I getObject(Class<T> type) throws ObjectException {
        return this.getObject(type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, I extends T> I getObject(Class<T> type, Annotation ... qualifiers) throws ObjectException {
        this.initialize();
        AssertUtils.assertNotNull(type);
        AssertUtils.assertNotNull(qualifiers);
        if (ObjectFactory.class.isAssignableFrom(type)) {
            return (I)ObjectUtils.cast(this);
        }
        ObjectInstance inst = this.getObjectInst(type, qualifiers);
        if (inst == null) {
            throw new ObjectException("Unsatisfied dependency (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers));
        }
        if (inst.definition.getScope() == ObjectScope.PROTOTYPE) {
            return (I)ObjectUtils.cast(this.produceObject(inst));
        }
        Object obj = inst.getInstance();
        if (obj == null) {
            Object object = this.mutex;
            synchronized (object) {
                obj = inst.getInstance();
                if (obj == null) {
                    obj = this.produceObject(inst);
                    inst.setInstance(obj);
                }
            }
        }
        return (I)ObjectUtils.cast(obj);
    }

    public <T> T postConstruct(final T obj) throws ObjectException {
        this.initialize();
        AssertUtils.assertNotNull(obj);
        ReflectionUtils.traverse(obj.getClass(), new ReflectionUtils.MethodHandler(){

            @Override
            public boolean matches(Method m) {
                return m.getDeclaredAnnotation(PostConstruct.class) != null;
            }

            @Override
            public boolean handleThenNext(Method m) throws ReflectionException {
                try {
                    m.setAccessible(true);
                    m.invoke(obj, new Object[0]);
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
                return false;
            }
        });
        return obj;
    }

    public <T> T preDestroy(T obj) throws ObjectException {
        this.initialize();
        AssertUtils.assertNotNull(obj);
        ObjectFactoryUtils.destroy(obj);
        return obj;
    }

    @Override
    public void destroy() throws ObjectException {
        for (ObjectInstance inst : this.instances) {
            Object obj = inst.getInstance();
            if (obj == null) continue;
            if (inst.definition.getProducer() == null) {
                this.preDestroy(obj);
            } else {
                inst.definition.getProducer().destroy(obj);
            }
            inst.setInstance(null);
        }
    }

    public Iterator<ObjectDefinition> getDefinitionIterator() {
        return new Iterator<ObjectDefinition>(){
            int index = -1;

            @Override
            public ObjectDefinition next() {
                ObjectInstance inst = ObjectFactory.this.instances.get(++this.index);
                return inst.definition;
            }

            @Override
            public boolean hasNext() {
                return this.index < ObjectFactory.this.instances.size() - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static abstract class InjectTraverser {
        InjectTraverser() {
        }

        public abstract boolean isValidationContext();

        public abstract void onParameter(Parameter var1) throws ObjectException;

        public abstract void onField(Field var1) throws ObjectException;

        public abstract void onMethod(Method var1) throws ObjectException;

        public void traverse(Class<?> implClass) throws ObjectException {
            Method[] methods;
            Class<?> clazz = null;
            if (this.isValidationContext()) {
                for (Constructor<?> ctor : implClass.getDeclaredConstructors()) {
                    if (ctor.getDeclaredAnnotation(Inject.class) == null) continue;
                    for (Parameter parameter : ctor.getParameters()) {
                        this.onParameter(parameter);
                    }
                    break;
                }
                for (clazz = implClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        if (method.getDeclaredAnnotation(Inject.class) == null) continue;
                        for (Parameter parameter : method.getParameters()) {
                            this.onParameter(parameter);
                        }
                    }
                }
            }
            for (clazz = implClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (field.getDeclaredAnnotation(Inject.class) == null) continue;
                    this.onField(field);
                }
            }
            if (!this.isValidationContext()) {
                for (clazz = implClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        if (method.getDeclaredAnnotation(Inject.class) == null) continue;
                        this.onMethod(method);
                    }
                }
            }
        }
    }
}

