/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.logging;

import com.appslandia.common.logging.AppLogger;
import com.appslandia.common.logging.AppLoggerManager;
import com.appslandia.common.utils.AssertUtils;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4JAppLoggerManager
extends AppLoggerManager {
    final LoggerContext context;

    public Log4JAppLoggerManager(String contextName, String configLocation) {
        this(Configurator.initialize((String)contextName, null, (String)configLocation));
    }

    public Log4JAppLoggerManager(String contextName, URI configLocation) {
        this(Configurator.initialize((String)contextName, null, (URI)configLocation));
    }

    public Log4JAppLoggerManager(String contextName, Configuration Configuration2) {
        this(Configurator.initialize(null, (Configuration)Configuration2));
    }

    public Log4JAppLoggerManager(String contextName, ConfigurationSource Configuration2) {
        this(Configurator.initialize(null, (ConfigurationSource)Configuration2));
    }

    public Log4JAppLoggerManager(LoggerContext context) {
        this.context = AssertUtils.assertNotNull(context);
    }

    @Override
    protected AppLogger createAppLogger(String name) {
        return new Log4JAppLogger((Logger)this.context.getLogger(name));
    }

    @Override
    public void close() {
        Configurator.shutdown((LoggerContext)this.context);
    }

    static class Log4JAppLogger
    implements AppLogger {
        final Logger logger;

        public Log4JAppLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isLoggable(AppLogger.Level level) {
            return this.isLoggable(Log4JAppLogger.toImplLevel(level));
        }

        @Override
        public void log(AppLogger.Level level, String message) {
            Level l = Log4JAppLogger.toImplLevel(level);
            if (this.isLoggable(l)) {
                this.logger.log(l, message);
            }
        }

        @Override
        public void log(AppLogger.Level level, String message, Throwable exception) {
            Level l = Log4JAppLogger.toImplLevel(level);
            if (this.isLoggable(l)) {
                this.logger.log(l, message, exception);
            }
        }

        @Override
        public void log(AppLogger.Level level, Supplier<String> msgSupplier) {
            Level l = Log4JAppLogger.toImplLevel(level);
            if (this.isLoggable(l)) {
                this.logger.log(l, msgSupplier);
            }
        }

        @Override
        public void log(AppLogger.Level level, Supplier<String> msgSupplier, Throwable exception) {
            Level l = Log4JAppLogger.toImplLevel(level);
            if (this.isLoggable(l)) {
                this.logger.log(l, msgSupplier, exception);
            }
        }

        private boolean isLoggable(Level level) {
            if (level == Level.ALL) {
                return true;
            }
            if (level == Level.TRACE) {
                return this.logger.isTraceEnabled();
            }
            if (level == Level.DEBUG) {
                return this.logger.isDebugEnabled();
            }
            if (level == Level.INFO) {
                return this.logger.isInfoEnabled();
            }
            if (level == Level.WARN) {
                return this.logger.isWarnEnabled();
            }
            if (level == Level.ERROR) {
                return this.logger.isErrorEnabled();
            }
            return false;
        }

        static Level toImplLevel(AppLogger.Level level) {
            switch (level) {
                case ALL: {
                    return Level.ALL;
                }
                case TRACE: {
                    return Level.TRACE;
                }
                case DEBUG: {
                    return Level.DEBUG;
                }
                case INFO: {
                    return Level.INFO;
                }
                case WARN: {
                    return Level.WARN;
                }
                case ERROR: {
                    return Level.ERROR;
                }
            }
            return Level.OFF;
        }
    }
}

