/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.utils.DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class SqlDateAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    final SimpleDateFormat formatter = DateUtils.newDateFormat("yyyy-MM-dd");
    final SimpleDateFormat parser = DateUtils.newDateFormat("yyyy-MM-dd");
    final Object fmtMutex = new Object();
    final Object parMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        Object object = this.fmtMutex;
        synchronized (object) {
            return new JsonPrimitive(this.formatter.format(src));
        }
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object object = this.parMutex;
        synchronized (object) {
            try {
                return new Date(this.parser.parse(json.getAsString()).getTime());
            }
            catch (ParseException ex) {
                throw new JsonParseException((Throwable)ex);
            }
        }
    }
}

