/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.jose.JoseException;
import com.appslandia.common.jose.JoseVerifier;
import com.appslandia.common.jose.JwtPayload;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class JwtPayloadVerifier
extends JoseVerifier<JwtPayload> {
    private String issuer;
    private List<String> audiences;
    private long leewayMs;

    @Override
    protected void init() throws Exception {
        this.audiences = CollectionUtils.unmodifiableList(this.audiences);
        super.addDelegate(new JoseVerifier.Delegate<JwtPayload, String>(this.issuer){

            @Override
            public void verify(JwtPayload obj) throws JoseException {
                if (!ObjectUtils.equals(obj.getIssuer(), this.arg)) {
                    throw new JoseException("issuer is not matched.");
                }
            }
        });
        super.addDelegate(new JoseVerifier.Delegate<JwtPayload, List<String>>(this.audiences){

            @Override
            public void verify(JwtPayload obj) throws JoseException {
                List<String> payloadAudiences = obj.getAudiences();
                if (payloadAudiences == null) {
                    payloadAudiences = Collections.emptyList();
                }
                if (payloadAudiences.size() > ((List)this.arg).size() || !((List)this.arg).containsAll(payloadAudiences)) {
                    throw new JoseException("audience is not matched.");
                }
            }
        });
        super.addDelegate(new JoseVerifier.Delegate<JwtPayload, Long>(Long.valueOf(this.leewayMs)){

            @Override
            public void verify(JwtPayload obj) throws JoseException {
                Date iat = obj.getIssuedAt();
                if (iat == null) {
                    return;
                }
                if (!DateUtils.isPastTime(iat.getTime(), (Long)this.arg)) {
                    throw new JoseException("IssuedAt is not matched.");
                }
            }
        });
        super.addDelegate(new JoseVerifier.Delegate<JwtPayload, Long>(Long.valueOf(this.leewayMs)){

            @Override
            public void verify(JwtPayload obj) throws JoseException {
                Date nbf = obj.getNotBefore();
                if (nbf == null) {
                    return;
                }
                if (!DateUtils.isPastTime(nbf.getTime(), (Long)this.arg)) {
                    throw new JoseException("jwt can't be used before " + DateUtils.iso8601DateTime(nbf));
                }
            }
        });
        super.addDelegate(new JoseVerifier.Delegate<JwtPayload, Long>(Long.valueOf(this.leewayMs)){

            @Override
            public void verify(JwtPayload obj) throws JoseException {
                Date expAt = obj.getExpiresAt();
                if (expAt == null) {
                    return;
                }
                if (!DateUtils.isFutureTime(expAt.getTime(), (Long)this.arg)) {
                    throw new JoseException("jwt can't be used after " + DateUtils.iso8601DateTime(expAt));
                }
            }
        });
    }

    public <A> JwtPayloadVerifier addDelegate(JoseVerifier.Delegate<JwtPayload, A> delegate) {
        super.addDelegate(delegate);
        return this;
    }

    public JwtPayloadVerifier setIssuer(String issuer) {
        this.assertNotInitialized();
        this.issuer = issuer;
        return this;
    }

    public JwtPayloadVerifier setAudiences(String ... audiences) {
        this.assertNotInitialized();
        if (audiences != null) {
            this.audiences = CollectionUtils.toList(audiences);
        }
        return this;
    }

    public JwtPayloadVerifier setLeewayMs(long leewayMs) {
        this.assertNotInitialized();
        this.leewayMs = leewayMs;
        return this;
    }
}

