/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.jose.JoseException;
import com.appslandia.common.jose.JoseHeader;
import com.appslandia.common.jose.JoseSigner;
import com.appslandia.common.jose.JoseUtils;
import com.appslandia.common.jose.JwsObject;
import com.appslandia.common.json.JsonException;
import com.appslandia.common.json.JsonProcessor;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ValueUtils;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JwsProcessor
extends InitializeObject {
    protected JsonProcessor jsonProcessor;
    protected Set<String> numericDateProps;
    protected JoseSigner joseSigner;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.jsonProcessor, "jsonProcessor is required.");
        this.numericDateProps = this.numericDateProps == null ? Collections.emptySet() : Collections.unmodifiableSet(this.numericDateProps);
        this.joseSigner = ValueUtils.valueOrDefault(this.joseSigner, JoseSigner.NONE);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.jsonProcessor != null) {
            this.jsonProcessor.destroy();
        }
        if (this.joseSigner != null) {
            this.joseSigner.destroy();
        }
    }

    protected void verifyHeader(JoseHeader header, boolean parsed) throws JoseException {
        if (header.getAlgorithm() == null) {
            throw new JoseException("alg is required.");
        }
        if (!header.getAlgorithm().equals(this.joseSigner.getAlgorithm())) {
            throw new JoseException("alg is not matched.");
        }
        if (!ObjectUtils.equals(header.getKid(), this.joseSigner.getKid())) {
            throw new JoseException("kid is not matched.");
        }
    }

    public String build(JwsObject jws) throws CryptoException, JsonException, JoseException {
        this.initialize();
        AssertUtils.assertNotNull(jws);
        AssertUtils.assertNotNull(jws.getHeader());
        AssertUtils.assertNotNull(jws.getPayload());
        this.verifyHeader(jws.getHeader(), false);
        StringWriter out = new StringWriter();
        this.jsonProcessor.write(out, jws.getHeader());
        String base64Header = BaseEncoder.BASE64_URL_NP.encode(out.toString().getBytes(CharsetUtils.UTF_8));
        String base64Payload = BaseEncoder.BASE64_URL_NP.encode(jws.getPayload());
        if (this.joseSigner == JoseSigner.NONE) {
            return base64Header + "." + base64Payload + ".";
        }
        String dataToSign = base64Header + "." + base64Payload;
        String base64Sig = BaseEncoder.BASE64_URL_NP.encode(this.joseSigner.sign(dataToSign.getBytes(CharsetUtils.UTF_8)));
        return dataToSign + "." + base64Sig;
    }

    public JwsObject parse(String jws) throws CryptoException, JsonException, JoseException {
        this.initialize();
        AssertUtils.assertNotNull(jws);
        String[] parts = JoseUtils.parseParts(jws);
        if (parts == null) {
            throw new JoseException("jws is invalid.");
        }
        if (parts[2] == null) {
            if (this.joseSigner != JoseSigner.NONE) {
                throw new JoseException("Signature is required.");
            }
            return this.doParse(parts[0], parts[1], null);
        }
        String dataToSign = parts[0] + "." + parts[1];
        byte[] signature = BaseEncoder.BASE64_URL_NP.decode(parts[2]);
        if (!this.joseSigner.verify(dataToSign.getBytes(CharsetUtils.UTF_8), signature)) {
            throw new JoseException("Failed to verify signature.");
        }
        return this.doParse(parts[0], parts[1], parts[2]);
    }

    protected JwsObject doParse(String headerPart, String payloadPart, String signature) throws JsonException, JoseException {
        String headerJson = new String(BaseEncoder.BASE64_URL_NP.decode(headerPart), CharsetUtils.UTF_8);
        byte[] payload = BaseEncoder.BASE64_URL_NP.decode(payloadPart);
        JoseHeader header = new JoseHeader(this.jsonProcessor.readAsLinkedMap(new StringReader(headerJson)));
        JoseUtils.convertToNumericDates(header, this.numericDateProps);
        this.verifyHeader(header, true);
        return new JwsObject(header, payload, signature);
    }

    public JsonProcessor getJsonProcessor() {
        this.initialize();
        return this.jsonProcessor;
    }

    public JwsProcessor setJsonProcessor(JsonProcessor jsonProcessor) {
        this.assertNotInitialized();
        this.jsonProcessor = jsonProcessor;
        return this;
    }

    public Set<String> getNumericDateProps() {
        this.initialize();
        return this.numericDateProps;
    }

    public JwsProcessor setNumericDateProps(String ... numericDateProps) {
        this.assertNotInitialized();
        if (numericDateProps != null) {
            this.numericDateProps = CollectionUtils.toSet(numericDateProps);
        }
        return this;
    }

    public JoseSigner getJoseSigner() {
        this.initialize();
        return this.joseSigner;
    }

    public JwsProcessor setJoseSigner(JoseSigner joseSigner) {
        this.assertNotInitialized();
        this.joseSigner = joseSigner;
        return this;
    }

    public JwsProcessor copy() {
        JwsProcessor impl = new JwsProcessor();
        if (this.jsonProcessor != null) {
            impl.jsonProcessor = this.jsonProcessor.copy();
        }
        if (this.numericDateProps != null) {
            impl.numericDateProps = new HashSet<String>(this.numericDateProps);
        }
        if (this.joseSigner != null) {
            impl.joseSigner = this.joseSigner.copy();
        }
        return impl;
    }
}

