/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.DsaDigester;
import com.appslandia.common.crypto.MacDigester;
import com.appslandia.common.utils.AssertUtils;

public class JoseSigner
extends InitializeObject {
    public static final JoseSigner NONE = new JoseSigner();
    private String algorithm;
    private Digester signer;
    private String kid;

    @Override
    protected void init() throws Exception {
        if (this.signer == null && this.algorithm == null) {
            this.algorithm = "none";
        }
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        if (this.signer == null) {
            AssertUtils.assertTrue(this.algorithm.equals("none"));
        } else {
            AssertUtils.assertTrue(!this.algorithm.equals("none"));
        }
        if (this.kid != null) {
            AssertUtils.assertNotNull(this.signer, "signer is required.");
        }
    }

    public byte[] sign(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertTrue(this != NONE);
        AssertUtils.assertNotNull(this.signer);
        return this.signer.digest(message);
    }

    public boolean verify(byte[] message, byte[] signature) throws CryptoException {
        this.initialize();
        AssertUtils.assertTrue(this != NONE);
        AssertUtils.assertNotNull(this.signer);
        return this.signer.verify(message, signature);
    }

    public String getAlgorithm() {
        this.initialize();
        return this.algorithm;
    }

    public JoseSigner setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public Digester getSigner() {
        this.initialize();
        return this.signer;
    }

    public JoseSigner setSigner(MacDigester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    public JoseSigner setSigner(DsaDigester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    public String getKid() {
        this.initialize();
        return this.kid;
    }

    public JoseSigner setKid(String kid) {
        this.assertNotInitialized();
        this.kid = kid;
        return this;
    }

    public JoseSigner copy() {
        if (this == NONE) {
            return NONE;
        }
        JoseSigner impl = new JoseSigner();
        impl.algorithm = this.algorithm;
        if (this.signer != null) {
            impl.signer = this.signer.copy();
        }
        impl.kid = this.kid;
        return impl;
    }
}

