/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class Jdk8DateFormatter<T extends TemporalAccessor>
implements Formatter {
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();

    protected abstract String getPattern(FormatProvider var1);

    protected abstract T parse(String var1, DateTimeFormatter var2) throws DateTimeParseException;

    @Override
    public final String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        return Jdk8DateFormatter.getFormatter(this.getPattern(formatProvider)).format((TemporalAccessor)this.getArgumentType().cast(obj));
    }

    public T parse(String str, FormatProvider formatProvider) throws FormatterException {
        if (str == null) {
            return null;
        }
        try {
            return this.parse(str, Jdk8DateFormatter.getFormatter(this.getPattern(formatProvider)));
        }
        catch (DateTimeParseException ex) {
            throw new FormatterException("An error occurred while parsing temporal (str=" + str + ", type=" + this.getArgumentType() + ")", this.getErrorMsgKey());
        }
    }

    protected static DateTimeFormatter getFormatter(String pattern) {
        return FORMATTER_CACHE.computeIfAbsent(pattern, p -> DateTimeFormatter.ofPattern(p));
    }
}

