/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.RoundRobinPool;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.PasswordDigester;
import com.appslandia.common.utils.AssertUtils;
import java.nio.charset.Charset;

public class PoolPasswordDigester
extends PasswordDigester {
    private PasswordDigester digester;
    private int poolSize;
    private PasswordDigester[] digesters;
    private RoundRobinPool<PasswordDigester> digesterPool;

    public PoolPasswordDigester() {
    }

    public PoolPasswordDigester(PasswordDigester digester) {
        this.digester = digester;
    }

    public PoolPasswordDigester(PasswordDigester digester, int poolSize) {
        this.digester = digester;
        this.poolSize = poolSize;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.digester, "digester is required.");
        this.poolSize = Math.max(Runtime.getRuntime().availableProcessors(), this.poolSize);
        this.digesters = new PasswordDigester[this.poolSize];
        this.digesters[0] = this.digester;
        for (int i = 1; i < this.poolSize; ++i) {
            this.digesters[i] = this.digester.copy();
        }
        this.digesterPool = new RoundRobinPool<PasswordDigester>(this.digesters);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.digesters != null) {
            for (PasswordDigester digester : this.digesters) {
                digester.destroy();
            }
        }
        super.destroy();
    }

    @Override
    public String digest(String password) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(password, "password is required.");
        return this.digesterPool.next().digest(password);
    }

    @Override
    public boolean verify(String password, String digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(password, "password is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        return this.digesterPool.next().verify(password, digested);
    }

    public PoolPasswordDigester setPasswordDigester(PasswordDigester passwordDigester) {
        this.assertNotInitialized();
        this.digester = passwordDigester;
        return this;
    }

    public PoolPasswordDigester setPoolSize(int poolSize) {
        this.assertNotInitialized();
        this.poolSize = poolSize;
        return this;
    }

    @Override
    public PoolPasswordDigester setSaltSize(int saltSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setIterationCount(int iterationCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setKeySize(int keySize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setProvider(String provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setDigester(Digester digester) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setTextCharset(Charset charset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester setTextCharset(String textCharset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolPasswordDigester copy() {
        PoolPasswordDigester impl = new PoolPasswordDigester().setPoolSize(this.poolSize);
        if (this.digester != null) {
            impl.digester = this.digester.copy();
        }
        return impl;
    }
}

