/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.base.DeployEnv;
import com.appslandia.common.base.EnableEnv;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.cdi.BeanDefinition;
import com.appslandia.common.cdi.BeanImpl;
import com.appslandia.common.cdi.CDIFactory;
import com.appslandia.common.cdi.CDIUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class CDIExtension
extends InitializeObject
implements Extension {
    final Set<Class<?>> excludedClasses = new HashSet();
    final Set<String> excludedPackages = new HashSet<String>();
    final Set<Class<? extends Annotation>> excludedAnnotations = new HashSet<Class<? extends Annotation>>();
    final List<BeanDefinition<?>> registeredBeans = new ArrayList();

    @Override
    protected void init() throws Exception {
    }

    protected CDIExtension excludeClasses(Class<?> ... beanClasses) {
        CollectionUtils.toSet(this.excludedClasses, beanClasses);
        return this;
    }

    protected CDIExtension excludePackages(String ... packages) {
        CollectionUtils.toSet(this.excludedPackages, packages);
        return this;
    }

    protected CDIExtension excludePackages(Class<?> ... beanClasses) {
        for (Class<?> clazz : beanClasses) {
            this.excludedPackages.add(clazz.getPackage().getName());
        }
        return this;
    }

    protected CDIExtension excludeAnnotations(Class<?> ... annotationClasses) {
        for (Class<?> clazz : annotationClasses) {
            this.excludedAnnotations.add((Class<? extends Annotation>)ObjectUtils.cast(clazz));
        }
        return this;
    }

    protected CDIExtension registerBean(BeanDefinition<?> definition) {
        this.registeredBeans.add(definition);
        return this;
    }

    protected boolean willExcludeClass(Class<?> beanClass) {
        return false;
    }

    protected void onExcludeClass(Class<?> beanClass) {
    }

    protected void onRegisterClass(Class<?> beanClass) {
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        this.initialize();
        Class beanClass = event.getAnnotatedType().getJavaClass();
        if (CDIExtension.willExcludeClasses(this.excludedClasses, beanClass)) {
            event.veto();
            this.onExcludeClass(beanClass);
            return;
        }
        if (CDIExtension.willExcludePackages(this.excludedPackages, beanClass)) {
            event.veto();
            this.onExcludeClass(beanClass);
            return;
        }
        if (CDIExtension.willExcludeAnnotations(this.excludedAnnotations, beanClass)) {
            event.veto();
            this.onExcludeClass(beanClass);
            return;
        }
        EnableEnv enableEnv = CDIExtension.getEnableEnv(beanClass);
        if (enableEnv != null && !DeployEnv.getCurrent().isAny(enableEnv.value())) {
            event.veto();
            this.onExcludeClass(beanClass);
            return;
        }
        if (this.willExcludeClass(beanClass)) {
            event.veto();
            this.onExcludeClass(beanClass);
            return;
        }
        this.onRegisterClass(beanClass);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        this.initialize();
        this.registerBeans(abd, beanManager);
    }

    protected void registerBeans(AfterBeanDiscovery registry, BeanManager beanManager) {
        for (BeanDefinition<?> definition : this.registeredBeans) {
            registry.addBean(new BeanImpl(definition, beanManager));
        }
    }

    public static boolean willExcludeClasses(Set<Class<?>> excludedClasses, Class<?> beanClass) {
        Method factoryMethod;
        if (excludedClasses.isEmpty()) {
            return false;
        }
        if (excludedClasses.contains(beanClass)) {
            return true;
        }
        return CDIFactory.class.isAssignableFrom(beanClass) && excludedClasses.contains((factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass))).getReturnType());
    }

    public static boolean willExcludePackages(Set<String> excludedPackages, Class<?> beanClass) {
        if (excludedPackages.isEmpty()) {
            return false;
        }
        for (String pkg : excludedPackages) {
            if (!beanClass.getPackage().getName().equals(pkg)) continue;
            return true;
        }
        if (CDIFactory.class.isAssignableFrom(beanClass)) {
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass));
            for (String pkg : excludedPackages) {
                if (!factoryMethod.getReturnType().getPackage().getName().equals(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean willExcludeAnnotations(Set<Class<? extends Annotation>> excludedAnnotations, Class<?> beanClass) {
        if (excludedAnnotations.isEmpty()) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : excludedAnnotations) {
            if (beanClass.getDeclaredAnnotation(annotationClass) == null) continue;
            return true;
        }
        if (CDIFactory.class.isAssignableFrom(beanClass)) {
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass));
            for (Class<? extends Annotation> annotationClass : excludedAnnotations) {
                if (factoryMethod.getDeclaredAnnotation(annotationClass) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static EnableEnv getEnableEnv(Class<?> beanClass) {
        EnableEnv enableEnv = beanClass.getDeclaredAnnotation(EnableEnv.class);
        if (enableEnv != null) {
            return enableEnv;
        }
        if (CDIFactory.class.isAssignableFrom(beanClass)) {
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass));
            return factoryMethod.getDeclaredAnnotation(EnableEnv.class);
        }
        return null;
    }
}

