/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.caching;

import com.appslandia.common.caching.AppCache;
import com.appslandia.common.caching.AppCacheManager;
import com.appslandia.common.caching.JCache;
import com.appslandia.common.utils.ObjectUtils;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;

public class JCacheManager
implements AppCacheManager {
    final CacheManager cacheManager;

    public JCacheManager() {
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
    }

    public JCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public <K, V> AppCache<K, V> createCache(String cacheName, Object configuration) {
        return new JCache(this.cacheManager.createCache(cacheName, (Configuration)ObjectUtils.cast(configuration)));
    }

    @Override
    public <K, V> AppCache<K, V> getCache(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        return cache != null ? new JCache(cache) : null;
    }

    @Override
    public <K, V> AppCache<K, V> getRequiredCache(String cacheName) throws IllegalArgumentException {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("cache is required (name=" + cacheName + ")");
        }
        return new JCache(cache);
    }

    @Override
    public void destroyCache(String cacheName) {
        this.cacheManager.destroyCache(cacheName);
    }

    @Override
    public Iterable<String> getCacheNames() {
        return this.cacheManager.getCacheNames();
    }

    @Override
    public void close() {
        this.cacheManager.close();
    }
}

