/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Provider;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;

public class Language
extends InitializeObject {
    public static final String TIME_FORMAT_24H = "HH:mm";
    public static final String TIME_FORMAT_24H_Z = "HH:mmXXX";
    public static final String TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String TIME_FORMAT_Z = "HH:mm:ss.SSSXXX";
    public static final Language EN = new Language().setLocale(Locale.US).setDateFormat("MM/dd/yyyy");
    public static final Language VI = new Language().setLocale(new Locale("vi", "VN")).setDateFormat("dd/MM/yyyy");
    private Locale locale;
    private String dateFormat;
    private String dateTimeFormat;
    private String dateTimeFormatZ;
    private String dateTimeFormat24H;
    private String dateTimeFormat24HZ;
    private static volatile Language __default;
    private static final Object MUTEX;
    private static Provider<Language> __provider;
    public static final String SYSTEM_PROP_LANGUAGE = "language";
    public static final String SYSTEM_ENV_LANGUAGE = "APPS_LANGUAGE";

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.locale, "locale is required.");
        AssertUtils.assertNotNull(this.dateFormat, "dateFormat is required.");
        this.dateTimeFormat = String.format("%s %s", this.dateFormat, TIME_FORMAT);
        this.dateTimeFormatZ = String.format("%s %s", this.dateFormat, TIME_FORMAT_Z);
        this.dateTimeFormat24H = String.format("%s %s", this.dateFormat, TIME_FORMAT_24H);
        this.dateTimeFormat24HZ = String.format("%s %s", this.dateFormat, TIME_FORMAT_24H_Z);
    }

    public String getId() {
        this.initialize();
        return this.locale.getLanguage();
    }

    public String getDisplayLanguage() {
        this.initialize();
        return this.locale.getDisplayLanguage(this.locale);
    }

    public Locale getLocale() {
        this.initialize();
        return this.locale;
    }

    public Language setLocale(Locale locale) {
        this.assertNotInitialized();
        this.locale = locale;
        return this;
    }

    public String getDateFormat() {
        this.initialize();
        return this.dateFormat;
    }

    public Language setDateFormat(String dateFormat) {
        this.assertNotInitialized();
        this.dateFormat = StringUtils.trimToNull(dateFormat);
        return this;
    }

    public String getDateTimeFormat() {
        this.initialize();
        return this.dateTimeFormat;
    }

    public String getDateTimeFormatZ() {
        this.initialize();
        return this.dateTimeFormatZ;
    }

    public String getDateTimeFormat24H() {
        this.initialize();
        return this.dateTimeFormat24H;
    }

    public String getDateTimeFormat24HZ() {
        this.initialize();
        return this.dateTimeFormat24HZ;
    }

    public String getTimeFormat24H() {
        this.initialize();
        return TIME_FORMAT_24H;
    }

    public String getTimeFormat24HZ() {
        this.initialize();
        return TIME_FORMAT_24H_Z;
    }

    public String getTimeFormat() {
        this.initialize();
        return TIME_FORMAT;
    }

    public String getTimeFormatZ() {
        this.initialize();
        return TIME_FORMAT_Z;
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.getId().toLowerCase(Locale.ENGLISH));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Language)) {
            return false;
        }
        Language another = (Language)obj;
        return this.getId().equalsIgnoreCase(another.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language getDefault() {
        Language obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = Language.initLanguage();
                }
            }
        }
        return obj;
    }

    public static void setDefault(Language obj) {
        AssertUtils.assertNull(__default);
        __default = obj;
    }

    public static void setProvider(Provider<Language> provider) {
        AssertUtils.assertNull(__default);
        __provider = provider;
    }

    private static Language initLanguage() {
        if (__provider != null) {
            return __provider.get();
        }
        try {
            String implName = System.getProperty(SYSTEM_PROP_LANGUAGE);
            if (implName == null) {
                implName = System.getenv(SYSTEM_ENV_LANGUAGE);
            }
            if (implName == null) {
                return EN;
            }
            Class implClass = ReflectionUtils.loadClass(implName, null);
            return (Language)ReflectionUtils.newInstance(implClass);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

