/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;

public class DeployEnv {
    public static final DeployEnv DEVELOPMENT = new DeployEnv("Development");
    public static final DeployEnv DEVELOPMENT2 = new DeployEnv("Development2");
    public static final DeployEnv TESTING = new DeployEnv("Testing");
    public static final DeployEnv STAGING = new DeployEnv("Staging");
    public static final DeployEnv PRODUCTION = new DeployEnv("Production");
    final String name;
    private static volatile DeployEnv current;
    private static final Object MUTEX;
    public static final String SYSTEM_PROP_DEPLOY_ENV = "deployEnv";
    public static final String SYSTEM_ENV_DEPLOY_ENV = "APPS_DEPLOY_ENV";

    private DeployEnv(String name) {
        this.name = AssertUtils.assertNotNull(name);
    }

    public boolean isDevelopment() {
        return this.equals(DEVELOPMENT) || this.equals(DEVELOPMENT2);
    }

    public boolean isTesting() {
        return this.equals(TESTING);
    }

    public boolean isStaging() {
        return this.equals(STAGING);
    }

    public boolean isProduction() {
        return this.equals(PRODUCTION);
    }

    public boolean isAny(String ... environments) {
        for (String env : environments) {
            if (!this.name.equalsIgnoreCase(env)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeployEnv)) {
            return false;
        }
        DeployEnv another = (DeployEnv)obj;
        return this.name.equalsIgnoreCase(another.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployEnv getCurrent() {
        DeployEnv obj = current;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = current;
                if (obj == null) {
                    current = obj = DeployEnv.initDeployEnv();
                }
            }
        }
        return obj;
    }

    public static void setCurrent(DeployEnv env) {
        AssertUtils.assertNull(current);
        current = env;
    }

    public static void setCurrent(String env) {
        AssertUtils.assertNotNull(env);
        AssertUtils.assertNull(current);
        current = DeployEnv.getDeployEnv(env);
    }

    private static DeployEnv initDeployEnv() {
        String env = StringUtils.trimToNull(System.getProperty(SYSTEM_PROP_DEPLOY_ENV));
        if (env == null) {
            env = StringUtils.trimToNull(System.getenv(SYSTEM_ENV_DEPLOY_ENV));
        }
        if (env == null) {
            env = DeployEnv.DEVELOPMENT.name;
        }
        return DeployEnv.getDeployEnv(env);
    }

    private static DeployEnv getDeployEnv(String env) {
        if (DeployEnv.DEVELOPMENT.name.equalsIgnoreCase(env)) {
            return DEVELOPMENT;
        }
        if (DeployEnv.DEVELOPMENT2.name.equalsIgnoreCase(env)) {
            return DEVELOPMENT2;
        }
        if (DeployEnv.TESTING.name.equalsIgnoreCase(env)) {
            return TESTING;
        }
        if (DeployEnv.STAGING.name.equalsIgnoreCase(env)) {
            return STAGING;
        }
        if (DeployEnv.PRODUCTION.name.equalsIgnoreCase(env)) {
            return PRODUCTION;
        }
        return new DeployEnv(env);
    }

    static {
        MUTEX = new Object();
    }
}

