// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.utils;

import java.util.regex.Pattern;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class StringUtils {

	public static final String EMPTY_STRING = "";
	public static final String[] EMPTY_ARRAY = {};

	public static String toLowerCase(String str) {
		if (str == null) {
			return null;
		}
		return str.toLowerCase();
	}

	public static String toUpperCase(String str) {
		if (str == null) {
			return null;
		}
		return str.toUpperCase();
	}

	public static String firstLowerCase(String str) {
		if (str == null) {
			return null;
		}
		if (!str.isEmpty()) {
			return str.substring(0, 1).toLowerCase() + str.substring(1);
		}
		return str;
	}

	public static String firstUpperCase(String str) {
		if (str == null) {
			return null;
		}
		if (!str.isEmpty()) {
			return str.substring(0, 1).toUpperCase() + str.substring(1);
		}
		return str;
	}

	public static String trimToNull(String str) {
		return trimToDefault(str, null);
	}

	public static String trimToEmpty(String str) {
		return str == null ? EMPTY_STRING : str.trim();
	}

	public static String trimToDefault(String str, String defaultValue) {
		if (str == null) {
			return defaultValue;
		}
		str = str.trim();
		return str.isEmpty() ? defaultValue : str;
	}

	public static String nullOrLowerCase(String str) {
		if (str == null) {
			return null;
		}
		return str.isEmpty() ? null : str.toLowerCase();
	}

	public static String nullOrUpperCase(String str) {
		if (str == null) {
			return null;
		}
		return str.isEmpty() ? null : str.toUpperCase();
	}

	public static boolean isNullOrEmpty(String str) {
		return (str == null) || (str.isEmpty());
	}

	private static final Pattern NON_DIGITS_PATTERN = Pattern.compile("[^\\d]+");

	public static String digitOnly(String str) {
		if (str == null) {
			return null;
		}
		str = NON_DIGITS_PATTERN.matcher(str).replaceAll(StringUtils.EMPTY_STRING);
		return !str.isEmpty() ? str : null;
	}
}
