// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.formatters;

import java.math.BigDecimal;
import java.math.BigInteger;

import com.appslandia.common.base.FormatProvider;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public interface Formatter {

	public static final String BYTE = Byte.class.getSimpleName();
	public static final String SHORT = Short.class.getSimpleName();
	public static final String INTEGER = Integer.class.getSimpleName();
	public static final String LONG = Long.class.getSimpleName();
	public static final String BIGINTEGER = BigInteger.class.getSimpleName();

	public static final String FLOAT = Float.class.getSimpleName();
	public static final String DOUBLE = Double.class.getSimpleName();
	public static final String BIGDECIMAL = BigDecimal.class.getSimpleName();

	public static final String SQL_DATE = java.sql.Date.class.getSimpleName();
	public static final String SQL_TIME = java.sql.Time.class.getSimpleName();
	public static final String SQL_DATETIME = java.sql.Timestamp.class.getSimpleName();
	public static final String SQL_TIME_24H = "Time24H";
	public static final String SQL_DATETIME_24H = "DateTime24H";

	public static final String LOCAL_DATE = "LocalDate";
	public static final String LOCAL_TIME = "LocalTime";
	public static final String LOCAL_DATETIME = "LocalDateTime";
	public static final String LOCAL_TIME_24H = "LocalTime24H";
	public static final String LOCAL_DATETIME_24H = "LocalDateTime24H";

	public static final String OFFSET_TIME = "OffsetTime";
	public static final String OFFSET_DATETIME = "OffsetDateTime";
	public static final String OFFSET_TIME_24H = "OffsetTime24H";
	public static final String OFFSET_DATETIME_24H = "OffsetDateTime24H";

	public static final String BOOLEAN = Boolean.class.getSimpleName();
	public static final String CHARACTER = Character.class.getSimpleName();
	public static final String ID_CODE = "IdCode";

	String getErrorMsgKey();

	Class<?> getArgumentType();

	String format(Object obj, FormatProvider formatProvider);

	Object parse(String str, FormatProvider formatProvider) throws FormatterException;
}
