// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Consumer;

import com.appslandia.common.utils.AssertUtils;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class BeanDefinition<T> {
	final Type[] types;
	final Annotation[] qualifiers;
	final Class<? extends Annotation> scope;
	final String name;

	final Class<? extends T> beanClass;
	final String passivationCapableId;
	final Consumer<? extends T> consumer;

	public BeanDefinition(Type[] types, Annotation[] qualifiers, Class<? extends Annotation> scope, String name, Class<? extends T> beanClass, String passivationCapableId, Consumer<? extends T> consumer) {
		this.types = AssertUtils.assertHasElements(types);
		this.qualifiers = qualifiers;
		this.scope = AssertUtils.assertNotNull(scope);
		this.name = name;

		this.beanClass = AssertUtils.assertNotNull(beanClass);
		this.passivationCapableId = AssertUtils.assertNotNull(passivationCapableId);
		this.consumer = consumer;
	}

	public Type[] getTypes() {
		return this.types;
	}

	public Annotation[] getQualifiers() {
		return this.qualifiers;
	}

	public Class<? extends Annotation> getScope() {
		return this.scope;
	}

	public String getName() {
		return this.name;
	}

	public Class<? extends T> getBeanClass() {
		return this.beanClass;
	}

	public String getPassivationCapableId() {
		return this.passivationCapableId;
	}

	public Consumer<? extends T> getConsumer() {
		return this.consumer;
	}
}
