/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class Jdk8DateUtils {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final DateTimeFormatter TIME_FORMATTER_Z = DateTimeFormatter.ofPattern("HH:mm:ss.SSSXXX");
    public static final DateTimeFormatter DATETIME_FORMATTER_Z = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public static LocalDateTime nowAtZone(ZoneOffset offset) {
        return OffsetDateTime.now().withOffsetSameInstant(offset).toLocalDateTime();
    }

    public static LocalDate iso8601Date(String date) throws DateTimeParseException {
        return date != null ? LocalDate.parse(date, DATE_FORMATTER) : null;
    }

    public static String iso8601Date(LocalDate date) {
        return date != null ? DATE_FORMATTER.format(date) : null;
    }

    public static LocalTime iso8601Time(String time) throws DateTimeParseException {
        return time != null ? LocalTime.parse(time, TIME_FORMATTER) : null;
    }

    public static String iso8601Time(LocalTime time) {
        return time != null ? TIME_FORMATTER.format(time) : null;
    }

    public static LocalDateTime iso8601DateTime(String dateTime) throws DateTimeParseException {
        return dateTime != null ? LocalDateTime.parse(dateTime, DATETIME_FORMATTER) : null;
    }

    public static String iso8601DateTime(LocalDateTime dateTime) {
        return dateTime != null ? DATETIME_FORMATTER.format(dateTime) : null;
    }

    public static OffsetTime iso8601TimeZ(String timeZ) throws DateTimeParseException {
        return timeZ != null ? OffsetTime.parse(timeZ, TIME_FORMATTER_Z) : null;
    }

    public static String iso8601TimeZ(OffsetTime timeZ) {
        return timeZ != null ? TIME_FORMATTER_Z.format(timeZ) : null;
    }

    public static OffsetDateTime iso8601DateTimeZ(String dateTimeZ) throws DateTimeParseException {
        return dateTimeZ != null ? OffsetDateTime.parse(dateTimeZ, DATETIME_FORMATTER_Z) : null;
    }

    public static String iso8601DateTimeZ(OffsetDateTime dateTimeZ) {
        return dateTimeZ != null ? DATETIME_FORMATTER_Z.format(dateTimeZ) : null;
    }
}

