/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.StringWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;

public class ExceptionUtils {
    public static Exception tryUnwrap(InvocationTargetException ex) {
        Throwable te = ex.getTargetException();
        if (te instanceof Exception) {
            return (Exception)te;
        }
        return ex;
    }

    public static String toStackTrace(Throwable ex) {
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        ex.printStackTrace(w);
        w.close();
        return out.toString();
    }

    public static String toCausePath(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        Throwable t = ex;
        while (true) {
            if (t.getMessage() != null) {
                sb.append(t.getMessage());
            } else {
                sb.append(t.getClass().getName());
            }
            if (t.getCause() == null) {
                return sb.toString();
            }
            sb.append(", cause=");
            t = t.getCause();
        }
    }
}

