/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.logging;

import com.appslandia.common.logging.AppLogger;
import com.appslandia.common.logging.AppLoggerManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilAppLoggerManager
extends AppLoggerManager {
    @Override
    protected AppLogger createAppLogger(String name) {
        return new JavaUtilAppLogger(Logger.getLogger(name));
    }

    static class JavaUtilAppLogger
    implements AppLogger {
        final Logger logger;

        public JavaUtilAppLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void trace(String message) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, message);
            }
        }

        @Override
        public void debug(String message) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, message);
            }
        }

        @Override
        public void info(String message) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, message);
            }
        }

        @Override
        public void warn(String message) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, message);
            }
        }

        @Override
        public void error(String message) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, message);
            }
        }

        @Override
        public void error(String message, Throwable exception) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, message, exception);
            }
        }
    }
}

