/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.gson;

import com.appslandia.common.utils.DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class SqlDateTimeAdapter
implements JsonSerializer<Timestamp>,
JsonDeserializer<Timestamp> {
    final SimpleDateFormat formatter = DateUtils.newDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    final SimpleDateFormat parser = DateUtils.newDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    final Object fmtMutex = new Object();
    final Object parMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
        Object object = this.fmtMutex;
        synchronized (object) {
            return new JsonPrimitive(this.formatter.format(src));
        }
    }

    public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object object = this.parMutex;
        synchronized (object) {
            try {
                return new Timestamp(this.parser.parse(json.getAsString()).getTime());
            }
            catch (ParseException ex) {
                throw new JsonParseException((Throwable)ex);
            }
        }
    }
}

