/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.gson;

import com.appslandia.common.utils.Jdk8DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalTime;

public class LocalTimeAdapter
implements JsonSerializer<LocalTime>,
JsonDeserializer<LocalTime> {
    public JsonElement serialize(LocalTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(Jdk8DateUtils.TIME_FORMATTER.format(src));
    }

    public LocalTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return LocalTime.parse(json.getAsString(), Jdk8DateUtils.TIME_FORMATTER);
    }
}

