/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.PropertyConfig;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.PbeEncryptor;
import com.appslandia.common.crypto.TextEncryptor;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class SecureConfig
extends PropertyConfig {
    private static final long serialVersionUID = 1L;
    final TextEncryptor textEncryptor;
    private static final String ENC_BEGIN = "ENC(";
    private static final String ENC_END = ")";

    public SecureConfig(char[] password) {
        this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(16).setPassword(password));
    }

    public SecureConfig(Encryptor encryptor) {
        this.textEncryptor = new TextEncryptor(encryptor);
    }

    public SecureConfig(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    @Override
    public SecureConfig load(InputStream is) throws IOException {
        super.load(is);
        return this;
    }

    @Override
    public SecureConfig load(Reader r) throws IOException {
        super.load(r);
        return this;
    }

    @Override
    public SecureConfig load(File file) throws IOException {
        super.load(file);
        return this;
    }

    @Override
    public SecureConfig load(String file) throws IOException {
        super.load(file);
        return this;
    }

    @Override
    public String getString(String key) throws CryptoException {
        String value = super.getString(key);
        if (value == null) {
            return null;
        }
        if (!SecureConfig.isEncryptedValue(value)) {
            return value;
        }
        return this.textEncryptor.decrypt(SecureConfig.parseEncryptedValue(value));
    }

    @Override
    public SecureConfig put(String key, String value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, boolean value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, int value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, long value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, float value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, double value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Boolean value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Integer value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Long value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Float value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Double value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Date value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Time value) {
        super.put(key, value);
        return this;
    }

    @Override
    public SecureConfig put(String key, Timestamp value) {
        super.put(key, value);
        return this;
    }

    protected void putsString(String key, String value) throws CryptoException {
        this.props.put(key, value != null ? SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(value)) : null);
    }

    public SecureConfig puts(String key, String value) throws CryptoException {
        this.putsString(key, StringUtils.trimToNull(value));
        return this;
    }

    public SecureConfig puts(String key, boolean value) throws CryptoException {
        this.putsString(key, Boolean.toString(value));
        return this;
    }

    public SecureConfig puts(String key, int value) throws CryptoException {
        this.putsString(key, Integer.toString(value));
        return this;
    }

    public SecureConfig puts(String key, long value) throws CryptoException {
        this.putsString(key, Long.toString(value));
        return this;
    }

    public SecureConfig puts(String key, float value) throws CryptoException {
        this.putsString(key, Float.toString(value));
        return this;
    }

    public SecureConfig puts(String key, double value) throws CryptoException {
        this.putsString(key, Double.toString(value));
        return this;
    }

    public SecureConfig puts(String key, Boolean value) throws CryptoException {
        this.putsString(key, value != null ? value.toString() : null);
        return this;
    }

    public SecureConfig puts(String key, Integer value) throws CryptoException {
        this.putsString(key, value != null ? value.toString() : null);
        return this;
    }

    public SecureConfig puts(String key, Long value) throws CryptoException {
        this.putsString(key, value != null ? value.toString() : null);
        return this;
    }

    public SecureConfig puts(String key, Float value) throws CryptoException {
        this.putsString(key, value != null ? value.toString() : null);
        return this;
    }

    public SecureConfig puts(String key, Double value) throws CryptoException {
        this.putsString(key, value != null ? value.toString() : null);
        return this;
    }

    public SecureConfig puts(String key, Date value) throws CryptoException {
        this.putsString(key, value != null ? DateUtils.iso8601Date(value) : null);
        return this;
    }

    public SecureConfig puts(String key, Time value) throws CryptoException {
        this.putsString(key, value != null ? DateUtils.iso8601Time(value) : null);
        return this;
    }

    public SecureConfig puts(String key, Timestamp value) throws CryptoException {
        this.putsString(key, value != null ? DateUtils.iso8601DateTime(value) : null);
        return this;
    }

    private static String markEncryptedValue(String value) {
        return ENC_BEGIN + value + ENC_END;
    }

    private static boolean isEncryptedValue(String value) {
        return value.startsWith(ENC_BEGIN) && value.endsWith(ENC_END);
    }

    private static String parseEncryptedValue(String value) {
        return value.substring(ENC_BEGIN.length(), value.length() - ENC_END.length());
    }
}

