/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.StringUtils;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecretMacDigester
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Mac mac;
    private byte[] secret;
    private SecretKeySpec keySpec;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        AssertUtils.assertNotNull(this.secret, "secret is required.");
        this.mac = this.provider == null ? Mac.getInstance(this.algorithm) : Mac.getInstance(this.algorithm, this.provider);
        this.keySpec = new SecretKeySpec(this.secret, this.algorithm);
        CryptoUtils.clear(this.secret);
    }

    @Override
    public int getDigestLength() {
        this.initialize();
        return this.mac.getMacLength();
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.keySpec != null) {
            CryptoUtils.tryDestroy(this.keySpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(this.keySpec);
                return this.mac.doFinal(message);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] mac) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(mac, "mac is required.");
        byte[] msgMac = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(this.keySpec);
                msgMac = this.mac.doFinal(message);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        return Arrays.equals(msgMac, mac);
    }

    public SecretMacDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = StringUtils.trimToNull(algorithm);
        return this;
    }

    public SecretMacDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }

    public SecretMacDigester setSecret(byte[] secret) {
        this.assertNotInitialized();
        this.secret = ArrayUtils.copy(secret);
        return this;
    }

    public SecretMacDigester setSecret(String secret) {
        AssertUtils.assertNotNull(secret);
        return this.setSecret(secret.getBytes(CharsetUtils.UTF_8));
    }

    @Override
    public SecretMacDigester copy() {
        SecretMacDigester impl = new SecretMacDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        impl.secret = ArrayUtils.copy(this.secret);
        return impl;
    }
}

