/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.PbeCrypto;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.crypto.SecureString;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class MacDigester
extends PbeCrypto
implements Digester {
    private String algorithm;
    private String provider;
    private Mac mac;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.keySize = ValueUtils.valueOrDefault(this.keySize, 32);
        AssertUtils.assertTrue(this.keySize > 0, "keySize is required.");
        this.mac = this.provider == null ? Mac.getInstance(this.algorithm) : Mac.getInstance(this.algorithm, this.provider);
    }

    @Override
    public int getDigestLength() {
        this.initialize();
        return this.saltSize + this.mac.getMacLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] salt = RandomUtils.nextBytes(this.random, this.saltSize);
        byte[] msgMac = null;
        SecretKey secretKey = this.createSecretKey(salt, this.algorithm);
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.tryDestroy(secretKey);
        }
        return ArrayUtils.append(salt, msgMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] mac) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(mac, "mac is required.");
        AssertUtils.assertTrue(mac.length > this.saltSize, "mac is invalid.");
        byte[] salt = new byte[this.saltSize];
        byte[] parsedMac = new byte[mac.length - this.saltSize];
        ArrayUtils.copy(mac, salt, parsedMac);
        byte[] msgMac = null;
        SecretKey secretKey = this.createSecretKey(salt, this.algorithm);
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.tryDestroy(secretKey);
        }
        return Arrays.equals(msgMac, parsedMac);
    }

    public MacDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = StringUtils.trimToNull(algorithm);
        return this;
    }

    public MacDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }

    @Override
    public MacDigester setSaltSize(int saltSize) {
        super.setSaltSize(saltSize);
        return this;
    }

    @Override
    public MacDigester setIterationCount(int iterationCount) {
        super.setIterationCount(iterationCount);
        return this;
    }

    @Override
    public MacDigester setKeySize(int keySize) {
        super.setKeySize(keySize);
        return this;
    }

    @Override
    public MacDigester setSecurePassword(SecureString password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public MacDigester setSecurePassword(char[] password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public MacDigester setPassword(char[] password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public MacDigester setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        super.setSecretKeyGenerator(secretKeyGenerator);
        return this;
    }

    @Override
    public MacDigester copy() {
        MacDigester impl = new MacDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        impl.setSaltSize(this.saltSize).setIterationCount(this.iterationCount).setKeySize(this.keySize);
        if (this.password != null) {
            if (this.password instanceof SecureString) {
                impl.password = ((SecureString)this.password).copy();
            } else {
                impl.setPassword((char[])this.password);
            }
        }
        if (this.secretKeyGenerator != null) {
            impl.secretKeyGenerator = this.secretKeyGenerator.copy();
        }
        return impl;
    }
}

