/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.DsaDigester;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.MathUtils;

public class DsaSigner
extends InitializeObject
implements Encryptor {
    private DsaDigester signer;

    public DsaSigner() {
    }

    public DsaSigner(DsaDigester signer) {
        this.signer = signer;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.signer, "signer is required.");
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.signer != null) {
            this.signer.destroy();
        }
        super.destroy();
    }

    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] digested = this.signer.digest(message);
        byte[] len = MathUtils.toByteArray(digested.length);
        return ArrayUtils.append(len, digested, message);
    }

    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] len = new byte[4];
        AssertUtils.assertTrue(message.length > 4, "message is invalid.");
        ArrayUtils.copy(message, len);
        int digestLength = MathUtils.toInt(len);
        AssertUtils.assertTrue(digestLength > 0, "message is invalid.");
        byte[] digested = new byte[digestLength];
        byte[] parsedMsg = new byte[message.length - digestLength - 4];
        System.arraycopy(message, 4, digested, 0, digestLength);
        System.arraycopy(message, 4 + digestLength, parsedMsg, 0, parsedMsg.length);
        if (!this.signer.verify(parsedMsg, digested)) {
            throw new CryptoException("message was tampered.");
        }
        return parsedMsg;
    }

    public DsaSigner setSigner(DsaDigester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    @Override
    public DsaSigner copy() {
        DsaSigner impl = new DsaSigner();
        if (this.signer != null) {
            impl.signer = this.signer.copy();
        }
        return impl;
    }
}

