/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.cdi.BeanDefinition;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;

public class BeanImpl<T>
implements Bean<T>,
PassivationCapable {
    final BeanDefinition<T> definition;
    final InjectionTarget<T> it;
    final Set<Annotation> qualifiers;
    final Set<Type> types;

    public BeanImpl(BeanDefinition<T> definition, BeanManager beanManager) {
        this.definition = definition;
        AnnotatedType at = beanManager.createAnnotatedType((Class)ObjectUtils.cast(definition.beanClass));
        this.it = beanManager.createInjectionTarget(at);
        this.qualifiers = ArrayUtils.hasElements(definition.qualifiers) ? CollectionUtils.unmodifiableSet(definition.qualifiers) : Collections.emptySet();
        this.types = CollectionUtils.unmodifiableSet(definition.types);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.definition.scope;
    }

    public String getName() {
        return this.definition.name;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return this.definition.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.it.getInjectionPoints();
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> ctx) {
        Object t = this.it.produce(ctx);
        this.it.inject(t, ctx);
        if (this.definition.consumer != null) {
            this.definition.consumer.accept(ObjectUtils.cast(t));
        }
        this.it.postConstruct(t);
        return (T)t;
    }

    public void destroy(T t, CreationalContext<T> ctx) {
        this.it.preDestroy(t);
        this.it.dispose(t);
        ctx.release();
    }

    public String getId() {
        return this.definition.passivationCapableId;
    }
}

