/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.ByteChunks;
import com.appslandia.common.base.TextBuilder;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ExceptionUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.ProtectionDomain;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;

public class ToStringBuilder {
    public static final MemberDecision DEFAULT_DECISION = new MemberDecision(){

        @Override
        protected Decision doGetDecision(Object value, Member member) {
            return Decision.TO_STRING;
        }
    };
    private int level;
    private int identTabs;
    private boolean singleLine;
    private MemberDecision memberDecision = DEFAULT_DECISION;

    public ToStringBuilder() {
        this(2);
    }

    public ToStringBuilder(int level) {
        this.setLevel(level);
    }

    public ToStringBuilder memberDecision(MemberDecision memberDecision) {
        this.memberDecision = memberDecision;
        return this;
    }

    public String toString(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            return builder.append("null").toString();
        }
        this.toStringObject(obj, 1, builder);
        return builder.toString();
    }

    public String toStringFields(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            return builder.append("null").toString();
        }
        this.toStringFields(obj, 1, builder);
        return builder.toString();
    }

    private void toStringObject(Object obj, int level, TextBuilder builder) {
        if (obj == null) {
            builder.append("null");
            return;
        }
        if (obj instanceof Iterable) {
            this.toStringIterator(obj, new IteratorIterator(((Iterable)obj).iterator()), level, builder);
            return;
        }
        if (obj instanceof Iterator) {
            this.toStringIterator(obj, new IteratorIterator((Iterator)obj), level, builder);
            return;
        }
        if (obj instanceof Enumeration) {
            this.toStringIterator(obj, new EnumerationIterator((Enumeration)obj), level, builder);
            return;
        }
        if (obj.getClass() == byte[].class) {
            builder.append(ObjectUtils.toObjectInfo(obj)).append(" (").append(((byte[])obj).length).append(")");
            return;
        }
        if (obj.getClass() == char[].class) {
            builder.append(ObjectUtils.toObjectInfo(obj)).append(" (").append(((char[])obj).length).append(")");
            return;
        }
        if (obj.getClass().isArray()) {
            this.toStringIterator(obj, new ArrayIterator(obj), level, builder);
            return;
        }
        if (obj instanceof Map) {
            this.toStringMap((Map)obj, level, builder);
            return;
        }
        if (obj instanceof Throwable) {
            builder.append(obj.getClass().getName()).append("(").append(ExceptionUtils.toCausePath((Throwable)obj)).append(")");
            return;
        }
        if (obj.getClass() == String.class) {
            builder.append("\"").append(obj).append("\"").append(" (").append(((String)obj).length()).append(")");
            return;
        }
        if (ToStringBuilder.useToString(obj)) {
            builder.append(obj);
            return;
        }
        if (ToStringBuilder.useTypeAndToString(obj)) {
            builder.append(obj.getClass().getName()).append("(").append(obj).append(")");
            return;
        }
        if (obj instanceof TimeZone) {
            builder.append(obj.getClass().getName()).append("(").append(((TimeZone)obj).getID()).append(")");
            return;
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            builder.append(cal.getClass().getName()).append("(date/time=").append(cal.getTime()).append(", zone=").append(cal.getTimeZone().getID()).append(")");
            return;
        }
        this.toStringFields(obj, level, builder);
    }

    private void toStringFields(Object obj, int level, TextBuilder builder) {
        Decision decision;
        builder.append(ObjectUtils.toObjectInfo(obj));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        for (Class<?> searchType = obj.getClass(); searchType != null; searchType = searchType.getSuperclass()) {
            AccessibleObject[] fields = searchType.getDeclaredFields();
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                if (!isFirst) {
                    builder.append(",");
                } else {
                    isFirst = false;
                }
                this.appendln(builder);
                this.appendtab(builder, level + this.identTabs);
                builder.append(field.getName()).append(": ");
                try {
                    field.setAccessible(true);
                    Object fieldVal = field.get(obj);
                    if (fieldVal == null) {
                        builder.append("null");
                        continue;
                    }
                    decision = this.memberDecision.getDecision(fieldVal, field);
                    if (decision == null || decision == Decision.TO_STRING) {
                        this.toStringObject(fieldVal, level + 1, builder);
                        continue;
                    }
                    if (decision == Decision.OBJECT_INFO) {
                        builder.append(ObjectUtils.toObjectInfo(fieldVal));
                        continue;
                    }
                    builder.append(fieldVal.getClass());
                    continue;
                }
                catch (Throwable ex) {
                    builder.append("error=").append(ExceptionUtils.toCausePath(ex));
                }
            }
        }
        try {
            for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
                String fieldName;
                if (((Method)accessibleObject).getName().equals("getClass") || (fieldName = ToStringBuilder.parseField((Method)accessibleObject)) == null || ReflectionUtils.findField(obj.getClass(), fieldName) != null) continue;
                if (!isFirst) {
                    builder.append(",");
                } else {
                    isFirst = false;
                }
                this.appendln(builder);
                this.appendtab(builder, level + this.identTabs);
                builder.append(((Method)accessibleObject).getName()).append("(): ");
                try {
                    Object mthVal = ((Method)accessibleObject).invoke(obj, new Object[0]);
                    if (mthVal == null) {
                        builder.append("null");
                        continue;
                    }
                    decision = this.memberDecision.getDecision(mthVal, (Member)((Object)accessibleObject));
                    if (decision == null || decision == Decision.TO_STRING) {
                        this.toStringObject(mthVal, level + 1, builder);
                        continue;
                    }
                    if (decision == Decision.OBJECT_INFO) {
                        builder.append(ObjectUtils.toObjectInfo(mthVal));
                        continue;
                    }
                    builder.append(mthVal.getClass());
                }
                catch (Throwable ex) {
                    builder.append("error=").append(ExceptionUtils.toCausePath(ex));
                }
            }
        }
        catch (Throwable ex) {
            builder.append("error=").append(ExceptionUtils.toCausePath(ex));
        }
        if (isFirst) {
            builder.append(" no fields/getters ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("]");
        }
    }

    private void toStringIterator(Object obj, ElementIterator iterator, int level, TextBuilder builder) {
        builder.append(ObjectUtils.toObjectInfo(obj));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder);
            this.appendtab(builder, level + this.identTabs);
            if (element == null) {
                builder.append("null");
                continue;
            }
            Decision decision = this.memberDecision.getDecision(element, null);
            if (decision == null || decision == Decision.TO_STRING) {
                this.toStringObject(element, level + 1, builder);
                continue;
            }
            if (decision == Decision.OBJECT_INFO) {
                builder.append(ObjectUtils.toObjectInfo(element));
                continue;
            }
            builder.append(element.getClass());
        }
        if (isFirst) {
            builder.append(" no elements ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("] (").append(iterator.getIndex()).append(")");
        }
    }

    private void toStringMap(Map<?, ?> map, int level, TextBuilder builder) {
        builder.append(ObjectUtils.toObjectInfo(map));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        for (Object key : map.keySet()) {
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder);
            this.appendtab(builder, level + this.identTabs);
            builder.append(key).append(": ");
            Object entryVal = map.get(key);
            if (entryVal == null) {
                builder.append("null");
                continue;
            }
            Decision decision = this.memberDecision.getDecision(entryVal, null);
            if (decision == null || decision == Decision.TO_STRING) {
                this.toStringObject(entryVal, level + 1, builder);
                continue;
            }
            if (decision == Decision.OBJECT_INFO) {
                builder.append(ObjectUtils.toObjectInfo(entryVal));
                continue;
            }
            builder.append(entryVal.getClass());
        }
        if (isFirst) {
            builder.append(" no entries ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("] (").append(map.size()).append(")");
        }
    }

    private void toStringAttributes(Object obj, Method getAttributeMethod, Set<String> attributes, int level, TextBuilder builder) {
        builder.append("[");
        boolean isFirst = true;
        for (String attribute : attributes) {
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder);
            this.appendtab(builder, level + this.identTabs);
            builder.append(attribute).append(": ");
            try {
                Object element = getAttributeMethod.invoke(obj, attribute);
                if (element == null) {
                    builder.append("null");
                    continue;
                }
                Decision decision = this.memberDecision.getDecision(element, null);
                if (decision == null || decision == Decision.TO_STRING) {
                    this.toStringObject(element, level + 1, builder);
                    continue;
                }
                if (decision == Decision.OBJECT_INFO) {
                    builder.append(ObjectUtils.toObjectInfo(element));
                    continue;
                }
                builder.append(element.getClass());
            }
            catch (Throwable ex) {
                builder.append("error=").append(ExceptionUtils.toCausePath(ex));
            }
        }
        if (isFirst) {
            builder.append(" no elements ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("]");
        }
    }

    public String toStringAttributes(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        try {
            Set<String> attributes = ToStringBuilder.getAttributeNames(obj, "getAttributeNames");
            Method method = ReflectionUtils.findMethod(obj.getClass(), "getAttribute");
            AssertUtils.assertNotNull(method);
            builder.append(ObjectUtils.toObjectInfo(obj)).append("-attributes");
            this.toStringAttributes(obj, method, attributes, 1, builder);
        }
        catch (Throwable ex) {
            builder.append("error=").append(ExceptionUtils.toCausePath(ex));
        }
        return builder.toString();
    }

    public String toStringHeaders(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        try {
            Set<String> attributes = ToStringBuilder.getAttributeNames(obj, "getHeaderNames");
            Method method = ReflectionUtils.findMethod(obj.getClass(), "getHeaders");
            AssertUtils.assertNotNull(method);
            builder.append(ObjectUtils.toObjectInfo(obj)).append("-headers");
            this.toStringAttributes(obj, method, attributes, 1, builder);
        }
        catch (Throwable ex) {
            builder.append("error=").append(ExceptionUtils.toCausePath(ex));
        }
        return builder.toString();
    }

    private static Set<String> getAttributeNames(Object obj, String methodName) throws Exception {
        Method method = ReflectionUtils.findMethod(obj.getClass(), methodName);
        AssertUtils.assertNotNull(method);
        Object attrs = method.invoke(obj, new Object[0]);
        TreeSet<String> names = new TreeSet<String>();
        if (attrs instanceof Enumeration) {
            Enumeration enm = (Enumeration)ObjectUtils.cast(attrs);
            while (enm.hasMoreElements()) {
                names.add((String)enm.nextElement());
            }
        } else {
            Collection attrCol = (Collection)ObjectUtils.cast(attrs);
            names.addAll(attrCol);
        }
        return names;
    }

    public ToStringBuilder setLevel(int level) {
        this.level = Math.max(level, 1);
        return this;
    }

    public ToStringBuilder setIdentTabs(int identTabs) {
        this.identTabs = Math.max(identTabs, 0);
        return this;
    }

    public ToStringBuilder setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
        return this;
    }

    private TextBuilder appendln(TextBuilder builder) {
        if (!this.singleLine) {
            builder.appendln();
        }
        return builder;
    }

    private TextBuilder appendtab(TextBuilder builder, int tabs) {
        if (this.singleLine) {
            builder.appendsp();
        } else {
            builder.appendtab(tabs);
        }
        return builder;
    }

    static boolean useToString(Object obj) {
        if (obj instanceof Number || obj.getClass() == Boolean.class || obj.getClass() == Character.class || obj instanceof CharSequence) {
            return true;
        }
        if (obj instanceof Date || obj.getClass().getName().startsWith("java.time.")) {
            return true;
        }
        if (obj.getClass().getName().startsWith("java.util.concurrent.atomic.")) {
            return true;
        }
        if (obj instanceof File || obj.getClass() == URL.class || obj.getClass() == URI.class || obj.getClass() == Void.class) {
            return true;
        }
        if (obj.getClass() == Locale.class || obj instanceof Charset || obj instanceof Enum || obj.getClass() == UUID.class) {
            return true;
        }
        if (obj.getClass() == TextBuilder.class) {
            return true;
        }
        return obj instanceof Type || obj instanceof Package || obj instanceof ProtectionDomain;
    }

    static boolean useTypeAndToString(Object obj) {
        if (obj instanceof ResourceBundle) {
            return true;
        }
        if (obj instanceof Reader || obj instanceof Writer || obj instanceof InputStream || obj instanceof OutputStream) {
            return true;
        }
        if (obj instanceof ByteBuffer || obj instanceof CharBuffer || obj instanceof ByteChunks) {
            return true;
        }
        return obj instanceof ClassLoader;
    }

    static String parseField(Method mth) {
        if (mth.getParameterTypes().length > 0) {
            return null;
        }
        if (mth.getReturnType() == Void.TYPE) {
            return null;
        }
        if (mth.getName().equals("get") || mth.getName().equals("is")) {
            return null;
        }
        if (mth.getName().startsWith("get")) {
            return StringUtils.firstLowerCase(mth.getName().substring(3));
        }
        if (mth.getName().startsWith("is")) {
            return StringUtils.firstLowerCase(mth.getName().substring(2));
        }
        return null;
    }

    static class EnumerationIterator
    implements ElementIterator {
        final Enumeration<?> obj;
        int index = 0;

        public EnumerationIterator(Enumeration<?> obj) {
            this.obj = obj;
        }

        @Override
        public boolean hasNext() {
            return this.obj.hasMoreElements();
        }

        @Override
        public Object next() {
            ++this.index;
            return this.obj.nextElement();
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class IteratorIterator
    implements ElementIterator {
        final Iterator<?> obj;
        int index = 0;

        public IteratorIterator(Iterator<?> obj) {
            this.obj = obj;
        }

        @Override
        public boolean hasNext() {
            return this.obj.hasNext();
        }

        @Override
        public Object next() {
            ++this.index;
            return this.obj.next();
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class ArrayIterator
    implements ElementIterator {
        final Object obj;
        final int len;
        int index = 0;

        public ArrayIterator(Object obj) {
            this.obj = obj;
            this.len = Array.getLength(obj);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public Object next() {
            return Array.get(this.obj, this.index++);
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static interface ElementIterator {
        public boolean hasNext();

        public Object next();

        public int getIndex();
    }

    public static enum Decision {
        TO_STRING,
        OBJECT_INFO,
        TYPE_INFO;

    }

    public static abstract class MemberDecision {
        static boolean isJdkClass(Class<?> type) {
            return type.getName().startsWith("java.") || type.getName().startsWith("javax.") || type.getName().startsWith("sun.") || type.getName().startsWith("com.sun.") || type.getName().startsWith("com.oracle.") || type.getName().startsWith("jdk.") || type.getName().startsWith("org.omg.") || type.getName().startsWith("org.w3c.");
        }

        public Decision getDecision(Object value, Member member) {
            EnableDecision decision = null;
            if (member != null) {
                Class<?> type;
                Class<?> clazz = type = member instanceof Field ? ((Field)member).getType() : ((Method)member).getReturnType();
                if (!MemberDecision.isJdkClass(type)) {
                    decision = member instanceof Field ? ((Field)member).getAnnotation(EnableDecision.class) : ((Method)member).getAnnotation(EnableDecision.class);
                }
            }
            if (decision == null && !MemberDecision.isJdkClass(value.getClass())) {
                decision = ReflectionUtils.findAnnotation(value.getClass(), EnableDecision.class);
            }
            if (decision != null) {
                return decision.value();
            }
            return this.doGetDecision(value, member);
        }

        protected abstract Decision doGetDecision(Object var1, Member var2);
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface EnableDecision {
        public Decision value();
    }
}

