/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BOM;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMInputStream
extends InputStream {
    private PushbackInputStream in;
    private BOM bom;

    public BOMInputStream(InputStream is) throws IOException {
        this.in = new PushbackInputStream(is, 4);
        byte[] bb = new byte[4];
        int count = this.in.read(bb);
        this.bom = BOM.parse(bb, count);
        if (count > 0) {
            this.in.unread(bb, 0, count);
        }
        if (this.bom != null) {
            this.in.skip(this.bom.length());
        }
    }

    public BOM getBOM() {
        return this.bom;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

