/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final Pattern NON_DIGITS_PATTERN = Pattern.compile("[^\\d]+");

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String toUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String firstLowerCase(String str) {
        if (str == null) {
            return null;
        }
        if (!str.isEmpty()) {
            return str.substring(0, 1).toLowerCase() + str.substring(1);
        }
        return str;
    }

    public static String firstUpperCase(String str) {
        if (str == null) {
            return null;
        }
        if (!str.isEmpty()) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }

    public static String trimToNull(String str) {
        return StringUtils.trimToDefault(str, null);
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY_STRING : str.trim();
    }

    public static String trimToDefault(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return (str = str.trim()).isEmpty() ? defaultValue : str;
    }

    public static String nullOrLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.isEmpty() ? null : str.toLowerCase();
    }

    public static String nullOrUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.isEmpty() ? null : str.toUpperCase();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String digitOnly(String str) {
        if (str == null) {
            return null;
        }
        return !(str = NON_DIGITS_PATTERN.matcher(str).replaceAll(EMPTY_STRING)).isEmpty() ? str : null;
    }
}

