/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.regex.Pattern;

public class BytesSizeUtils {
    private static final Pattern BYTES_SIZE_PATTERN = Pattern.compile("((\\d+.\\d+|\\d+)(TB|GB|MB|KB|B)\\s*)+", 2);
    public static final long __1KB_BYTES = 1024L;
    public static final long __1MB_BYTES = 0x100000L;
    public static final long __1GB_BYTES = 0x40000000L;

    public static long translateToBytes(String sizeAmt) throws IllegalArgumentException {
        sizeAmt = StringUtils.trimToNull(sizeAmt);
        AssertUtils.assertNotNull(sizeAmt, "sizeAmt is required.");
        AssertUtils.assertTrue(BYTES_SIZE_PATTERN.matcher(sizeAmt).matches(), "sizeAmt is invalid format.");
        double result = 0.0;
        int i = 0;
        while (i < sizeAmt.length()) {
            int k;
            int j = i;
            while (Character.isDigit(sizeAmt.charAt(j)) || sizeAmt.charAt(j) == '.') {
                ++j;
            }
            for (k = j; k <= sizeAmt.length() - 1 && (Character.isLetter(sizeAmt.charAt(k)) || sizeAmt.charAt(k) == ' '); ++k) {
            }
            float amt = Float.parseFloat(sizeAmt.substring(i, j));
            String unit = sizeAmt.substring(j, k).trim();
            result = "GB".equalsIgnoreCase(unit) ? (result += (double)(1.0737418E9f * amt)) : ("MB".equalsIgnoreCase(unit) ? (result += (double)(1048576.0f * amt)) : ("KB".equalsIgnoreCase(unit) ? (result += (double)(1024.0f * amt)) : (result += (double)amt)));
            i = k;
        }
        return (long)result;
    }
}

