/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.threading;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_SEQ = new AtomicInteger(0);
    final ThreadGroup group;
    final String prefix;
    final AtomicInteger seq = new AtomicInteger(0);

    public DaemonThreadFactory() {
        SecurityManager sm = System.getSecurityManager();
        this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.prefix = "pool-" + POOL_SEQ.incrementAndGet() + "-daemon-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.prefix + this.seq.incrementAndGet(), 0L);
        if (!t.isDaemon()) {
            t.setDaemon(true);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

