/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import javax.inject.Qualifier;

public class AnnotationUtils {
    public static boolean equals(Annotation[] src, Annotation[] annotations) {
        if (annotations.length != src.length) {
            return false;
        }
        if (annotations.length == 0) {
            return true;
        }
        for (Annotation ann2 : annotations) {
            Annotation ann1;
            boolean matched = false;
            Annotation[] annotationArray = src;
            int n = annotationArray.length;
            for (int i = 0; i < n && !(matched = (ann1 = annotationArray[i]).equals(ann2)); ++i) {
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnnotations(Annotation[] src, Annotation[] annotations) {
        if (annotations.length == 0) {
            return src.length == 0;
        }
        for (Annotation ann2 : annotations) {
            Annotation ann1;
            boolean matched = false;
            Annotation[] annotationArray = src;
            int n = annotationArray.length;
            for (int i = 0; i < n && !(matched = (ann1 = annotationArray[i]).equals(ann2)); ++i) {
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static Annotation[] parseQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>(3);
        for (Annotation ann : annotations) {
            if (ann.annotationType().getDeclaredAnnotation(Qualifier.class) == null) continue;
            qualifiers.add(ann);
        }
        return !qualifiers.isEmpty() ? qualifiers.toArray(new Annotation[qualifiers.size()]) : ReflectionUtils.EMPTY_ANNOTATIONS;
    }

    public static Annotation[] parseQualifiers(Field field) {
        return AnnotationUtils.parseQualifiers(field.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(Method method) {
        return AnnotationUtils.parseQualifiers(method.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(Parameter parameter) {
        return AnnotationUtils.parseQualifiers(parameter.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(Class<?> clazz) {
        return AnnotationUtils.parseQualifiers(clazz.getDeclaredAnnotations());
    }
}

