/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jwt;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.JsonProcessor;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.jwt.JwtUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;

public class JwtBuilder
extends InitializeObject {
    private JsonProcessor jsonProcessor;
    private Digester digester;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.jsonProcessor, "jsonProcessor is required.");
        AssertUtils.assertNotNull(this.digester, "digester is required.");
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.digester != null) {
            this.digester.destroy();
        }
    }

    public String build(Object header, Object payload) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(header);
        AssertUtils.assertNotNull(payload);
        StringWriter out = new StringWriter();
        this.jsonProcessor.write(out, header);
        String base64Header = BaseEncoder.BASE64_URL_NP.encode(out.toString().getBytes(CharsetUtils.UTF_8));
        out.reset();
        this.jsonProcessor.write(out, payload);
        String base64Payload = BaseEncoder.BASE64_URL_NP.encode(out.toString().getBytes(CharsetUtils.UTF_8));
        String dataToSign = base64Header + "." + base64Payload;
        String base64Sig = BaseEncoder.BASE64_URL_NP.encode(this.digester.digest(dataToSign.getBytes(CharsetUtils.UTF_8)));
        return dataToSign + "." + base64Sig;
    }

    public boolean verify(String jwt) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(jwt);
        String[] parts = JwtUtils.parseParts(jwt);
        if (parts == null) {
            return false;
        }
        String dataToSign = parts[0] + "." + parts[1];
        byte[] signature = BaseEncoder.BASE64_URL_NP.decode(parts[2]);
        return this.digester.verify(dataToSign.getBytes(CharsetUtils.UTF_8), signature);
    }

    public JwtBuilder setJsonProcessor(JsonProcessor jsonProcessor) {
        this.assertNotInitialized();
        this.jsonProcessor = jsonProcessor;
        return this;
    }

    public JwtBuilder setDigester(Digester digester) {
        this.assertNotInitialized();
        this.digester = digester;
        return this;
    }
}

