/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.gson;

import com.appslandia.common.utils.Jdk8DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.OffsetTime;

public class OffsetTimeAdapter
implements JsonSerializer<OffsetTime>,
JsonDeserializer<OffsetTime> {
    public JsonElement serialize(OffsetTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(Jdk8DateUtils.TIME_FORMATTER_Z.format(src));
    }

    public OffsetTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return OffsetTime.parse(json.getAsString(), Jdk8DateUtils.TIME_FORMATTER_Z);
    }
}

