/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.gson;

import com.appslandia.common.base.JsonException;
import com.appslandia.common.base.JsonProcessor;
import com.appslandia.common.base.NotBind;
import com.appslandia.common.gson.DateAdapter;
import com.appslandia.common.gson.SqlDateAdapter;
import com.appslandia.common.gson.SqlDateTimeAdapter;
import com.appslandia.common.gson.SqlTimeAdapter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class GsonProcessor
extends JsonProcessor {
    private Gson gson;
    private GsonBuilder builder;

    @Override
    protected void init() throws Exception {
        if (this.builder == null) {
            this.builder = GsonProcessor.newGsonBuilder(true);
        }
        this.gson = this.builder.create();
    }

    @Override
    public void write(Writer out, Object obj) throws JsonException {
        this.initialize();
        try {
            this.gson.toJson(obj, (Appendable)out);
        }
        catch (JsonIOException ex) {
            throw new JsonException(ex);
        }
    }

    @Override
    public <T> T read(Reader reader, Class<? extends T> resultClass) throws JsonException {
        this.initialize();
        try {
            return (T)this.gson.fromJson(reader, resultClass);
        }
        catch (JsonSyntaxException ex) {
            throw new JsonException(ex);
        }
        catch (JsonIOException ex) {
            throw new JsonException(ex);
        }
    }

    public GsonProcessor setBuilder(GsonBuilder builder) {
        this.assertNotInitialized();
        this.builder = builder;
        return this;
    }

    @Override
    public GsonProcessor copy() {
        return new GsonProcessor().setBuilder(this.builder);
    }

    public static GsonBuilder newGsonBuilder(boolean serializeNulls) {
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes attrs) {
                return attrs.getAnnotation(NotBind.class) != null;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }});
        builder.registerTypeAdapter(java.util.Date.class, (Object)new DateAdapter());
        builder.registerTypeAdapter(Date.class, (Object)new SqlDateAdapter());
        builder.registerTypeAdapter(Time.class, (Object)new SqlTimeAdapter());
        builder.registerTypeAdapter(Timestamp.class, (Object)new SqlDateTimeAdapter());
        return builder;
    }
}

