/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.easyrecord;

import com.appslandia.common.easyrecord.Record;
import com.appslandia.common.jdbc.JdbcUtils;
import com.appslandia.common.jdbc.ResultSetImpl;
import com.appslandia.common.jdbc.ResultSetMapper;
import com.appslandia.common.jdbc.StatementImpl;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class RecordUtils {
    public static Record executeSingle(StatementImpl stat) throws SQLException {
        ResultSetMapper<Record> mapper = new ResultSetMapper<Record>(){

            @Override
            public Record map(ResultSetImpl rs) throws SQLException {
                Record record = new Record();
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                    String fieldLabel = rsmd.getColumnLabel(col);
                    record.set(fieldLabel, rs.getObject(col));
                }
                return record;
            }
        };
        return stat.executeSingle(mapper);
    }

    public static List<Record> executeList(StatementImpl stat) throws SQLException {
        try (ResultSetImpl rs = stat.executeResult();){
            List<Record> list = RecordUtils.executeList(rs);
            return list;
        }
    }

    public static List<Record> executeList(ResultSetImpl rs) throws SQLException {
        ArrayList<Record> list = new ArrayList<Record>();
        final String[] columnLabels = JdbcUtils.getColumnLabels(rs);
        ResultSetMapper<Record> mapper = new ResultSetMapper<Record>(){

            @Override
            public Record map(ResultSetImpl rs) throws SQLException {
                Record record = new Record();
                for (int col = 1; col <= columnLabels.length; ++col) {
                    record.set(columnLabels[col - 1], rs.getObject(col));
                }
                return record;
            }
        };
        while (rs.next()) {
            list.add((Record)mapper.map(rs));
        }
        return list;
    }
}

