/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.Base64Delegate;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.utils.CharsetUtils;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class PKIUtils {
    public static byte[] toDerEncoded(String pem) {
        pem = PKIUtils.removeBeginEnd(pem);
        return Base64Delegate.getDefault().mimeDecode(pem.getBytes(CharsetUtils.US_ASCII));
    }

    public static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)-----", "");
        return pem.trim();
    }

    public static String toPemEncoded(byte[] der, String label) {
        StringWriter pem = new StringWriter();
        PrintWriter pw = new PrintWriter(pem);
        pw.append("-----BEGIN ").append(label).println("-----");
        pw.write(new String(Base64Delegate.getDefault().mimeEncode(der), CharsetUtils.US_ASCII));
        pw.println();
        pw.append("-----END ").append(label).println("-----");
        pw.close();
        return pem.toString();
    }

    public static String toPemLabel(PublicKey key) {
        return key.getAlgorithm() + " PUBLIC KEY";
    }

    public static String toPemLabel(PrivateKey key) {
        return key.getAlgorithm() + " PRIVATE KEY";
    }

    public static String toPemEncoded(PublicKey key) {
        return PKIUtils.toPemEncoded(key.getEncoded(), PKIUtils.toPemLabel(key));
    }

    public static String toPemEncoded(PrivateKey key) {
        return PKIUtils.toPemEncoded(key.getEncoded(), PKIUtils.toPemLabel(key));
    }

    public static String toPemLabel(Certificate cert) {
        return cert.getType() + " CERTIFICATE";
    }

    public static String toPemEncoded(Certificate cert) throws CertificateEncodingException {
        return PKIUtils.toPemEncoded(cert.getEncoded(), PKIUtils.toPemLabel(cert));
    }
}

