/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.PKIUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.IOUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactoryUtil
extends InitializeObject {
    private String algorithm;
    private String provider;
    private KeyFactory keyFactory;

    public KeyFactoryUtil() {
    }

    public KeyFactoryUtil(String algorithm) {
        this.algorithm = algorithm;
    }

    public KeyFactoryUtil(String algorithm, String provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.keyFactory = this.provider == null ? KeyFactory.getInstance(this.algorithm) : KeyFactory.getInstance(this.algorithm, this.provider);
    }

    public PrivateKey toPrivateKey(String keyInPem) throws CryptoException {
        this.initialize();
        byte[] der = PKIUtils.toDerEncoded(keyInPem);
        try {
            PrivateKey privateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(der));
            return privateKey;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.clear(der);
        }
    }

    public PrivateKey toPrivateKey(InputStream keyInDer) throws IOException, CryptoException {
        this.initialize();
        byte[] der = IOUtils.toByteArray(keyInDer);
        try {
            PrivateKey privateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(der));
            return privateKey;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.clear(der);
        }
    }

    public PublicKey toPublicKey(String keyInPem) throws CryptoException {
        this.initialize();
        try {
            byte[] der = PKIUtils.toDerEncoded(keyInPem);
            return this.keyFactory.generatePublic(new X509EncodedKeySpec(der));
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public PublicKey toPublicKey(InputStream keyInDer) throws IOException, CryptoException {
        this.initialize();
        try {
            return this.keyFactory.generatePublic(new X509EncodedKeySpec(IOUtils.toByteArray(keyInDer)));
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public PrivateKey copy(PrivateKey key) throws CryptoException {
        this.initialize();
        byte[] encoded = key.getEncoded();
        try {
            PrivateKey privateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            return privateKey;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.clear(encoded);
        }
    }

    public PublicKey copy(PublicKey key) throws CryptoException {
        this.initialize();
        try {
            return this.keyFactory.generatePublic(new X509EncodedKeySpec(key.getEncoded()));
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public KeyFactoryUtil setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = StringUtils.trimToNull(algorithm);
        return this;
    }

    public KeyFactoryUtil setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }
}

