/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class Permutation {
    final int n;
    private byte[] flags;
    private int remaining;
    final Random random = new SecureRandom();

    public Permutation(int n) {
        this.n = n;
    }

    private void initialize() {
        if (this.flags == null) {
            this.flags = new byte[this.n];
            this.remaining = this.n;
        }
    }

    public int next() {
        this.initialize();
        if (this.remaining == 0) {
            throw new NoSuchElementException("Permutation.next()");
        }
        int rdIndex = RandomUtils.nextInt(this.random, 0, this.remaining - 1);
        int index = -1;
        for (int i = 0; i < this.n; ++i) {
            if (this.flags[i] != 0 || ++index != rdIndex) continue;
            this.flags[i] = 1;
            --this.remaining;
            return i;
        }
        return -1;
    }

    public boolean hasNext() {
        this.initialize();
        return this.remaining > 0;
    }

    public void reset() {
        if (this.flags != null) {
            Arrays.fill(this.flags, (byte)0);
            this.remaining = this.n;
        }
    }
}

