/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.Mutex;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Mutex mutex = new Mutex();
    final Map<K, V> cache;

    public LruCache(final int cacheSize) {
        this.cache = new LinkedHashMap<K, V>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.cache.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(K k) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            return this.cache.containsKey(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K k) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            return this.cache.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            return this.cache.get(k);
        }
    }
}

