/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.ByteChunks;
import com.appslandia.common.base.JavaSerializer;
import com.appslandia.common.base.JavaSerializerException;
import com.appslandia.common.utils.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JdkSerializer
extends JavaSerializer {
    final int byteChunksBlockSize;

    public JdkSerializer() {
        this(512);
    }

    public JdkSerializer(int byteChunksBlockSize) {
        this.byteChunksBlockSize = byteChunksBlockSize;
    }

    @Override
    public ByteChunks serialize(Object obj) throws JavaSerializerException {
        try {
            ByteChunks bc = new ByteChunks(this.byteChunksBlockSize);
            ObjectOutputStream oos = new ObjectOutputStream(bc);
            oos.writeObject(obj);
            oos.flush();
            return bc;
        }
        catch (IOException ex) {
            throw new JavaSerializerException(ex);
        }
    }

    @Override
    public <T> T deserialize(byte[] ser) throws JavaSerializerException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ser));
            return ObjectUtils.cast(ois.readObject());
        }
        catch (Exception ex) {
            throw new JavaSerializerException(ex);
        }
    }
}

