/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ByteChunks
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int blockSize;
    private ChunkList chunkList;
    private long count;
    private int lastLen;

    public ByteChunks() {
        this(512);
    }

    public ByteChunks(int blockSize) {
        AssertUtils.assertTrue(blockSize > 0);
        this.blockSize = blockSize;
        this.chunkList = new ChunkList(new byte[this.blockSize]);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] lastBuf = this.chunkList.last.buf;
        int lenLeft = lastBuf.length - this.lastLen;
        if (lenLeft >= 1) {
            lastBuf[this.lastLen] = (byte)b;
            ++this.lastLen;
        } else {
            this.chunkList.insert(new byte[this.blockSize]);
            this.chunkList.last.buf[0] = (byte)b;
            this.lastLen = 1;
        }
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] lastBuf = this.chunkList.last.buf;
        int lenLeft = lastBuf.length - this.lastLen;
        if (lenLeft >= len) {
            System.arraycopy(b, off, lastBuf, this.lastLen, len);
            this.lastLen += len;
        } else {
            int addLen = len - lenLeft;
            int addBlocks = addLen / this.blockSize;
            if (addBlocks * this.blockSize < addLen) {
                ++addBlocks;
            }
            this.chunkList.insert(new byte[addBlocks * this.blockSize]);
            if (lenLeft == 0) {
                System.arraycopy(b, off, this.chunkList.last.buf, 0, len);
                this.lastLen = len;
            } else {
                System.arraycopy(b, off, lastBuf, this.lastLen, lenLeft);
                System.arraycopy(b, off + lenLeft, this.chunkList.last.buf, 0, len - lenLeft);
                this.lastLen = len - lenLeft;
            }
        }
        this.count += (long)len;
    }

    public void writeTo(OutputStream out) throws IOException {
        Chunk c = this.chunkList.first;
        while (c != null) {
            if (c != this.chunkList.last) {
                out.write(c.buf, 0, c.buf.length);
            } else {
                out.write(c.buf, 0, this.lastLen);
            }
            c = c.next;
        }
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[(int)this.count];
        int destPos = 0;
        Chunk c = this.chunkList.first;
        while (c != null) {
            if (c != this.chunkList.last) {
                System.arraycopy(c.buf, 0, bytes, destPos, c.buf.length);
                destPos += c.buf.length;
            } else {
                System.arraycopy(c.buf, 0, bytes, destPos, this.lastLen);
                destPos += this.lastLen;
            }
            c = c.next;
        }
        return bytes;
    }

    public int getChunkCount() {
        int count = 0;
        Chunk c = this.chunkList.first;
        while (c != null) {
            ++count;
            c = c.next;
        }
        return count;
    }

    public byte[] digest(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        Chunk c = this.chunkList.first;
        while (c != null) {
            if (c != this.chunkList.last) {
                md.update(c.buf, 0, c.buf.length);
            } else {
                md.update(c.buf, 0, this.lastLen);
            }
            c = c.next;
        }
        return md.digest();
    }

    public void iterate(ChunkIterator iterator) throws IOException {
        Chunk c = this.chunkList.first;
        while (c != null) {
            if (c != this.chunkList.last) {
                iterator.nextChunk(c.buf, c.buf.length);
            } else {
                iterator.nextChunk(c.buf, this.lastLen);
            }
            c = c.next;
        }
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), 0, (int)this.count, charset);
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), 0, (int)this.count, charset);
    }

    public String toString() {
        return new String(this.toByteArray(), 0, (int)this.count, CharsetUtils.UTF_8);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0L;
    }

    public void reset() {
        this.chunkList.first.next = null;
        this.chunkList.last = this.chunkList.first;
        this.count = 0L;
        this.lastLen = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.blockSize);
        out.writeLong(this.count);
        out.writeInt(this.lastLen);
        out.writeInt(this.getChunkCount());
        Chunk c = this.chunkList.first;
        while (c != null) {
            out.writeObject(c.buf);
            c = c.next;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.blockSize = in.readInt();
        this.count = in.readLong();
        this.lastLen = in.readInt();
        for (int chunkCount = in.readInt(); chunkCount > 0; --chunkCount) {
            byte[] buf = (byte[])in.readObject();
            if (this.chunkList == null) {
                this.chunkList = new ChunkList(buf);
                continue;
            }
            this.chunkList.insert(buf);
        }
    }

    private static class Chunk {
        final byte[] buf;
        Chunk next;

        public Chunk(byte[] buf) {
            this.buf = buf;
        }
    }

    private static class ChunkList {
        final Chunk first;
        Chunk last;

        public ChunkList(byte[] buf) {
            this.last = this.first = new Chunk(buf);
        }

        public void insert(byte[] buf) {
            Chunk c;
            this.last.next = c = new Chunk(buf);
            this.last = c;
        }
    }

    public static interface ChunkIterator {
        public void nextChunk(byte[] var1, int var2) throws IOException;
    }
}

