// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class JavaUtilAppLoggerManager extends AppLoggerManager {

	@Override
	protected AppLogger createAppLogger(String name) {
		return new JavaUtilAppLogger(Logger.getLogger(name));
	}

	static class JavaUtilAppLogger implements AppLogger {

		final Logger logger;

		public JavaUtilAppLogger(Logger logger) {
			this.logger = logger;
		}

		@Override
		public void trace(String message) {
			if (this.logger.isLoggable(Level.FINEST)) {
				this.logger.log(Level.FINEST, message);
			}
		}

		@Override
		public void debug(String message) {
			if (this.logger.isLoggable(Level.FINE)) {
				this.logger.log(Level.FINE, message);
			}
		}

		@Override
		public void info(String message) {
			if (this.logger.isLoggable(Level.INFO)) {
				this.logger.log(Level.INFO, message);
			}
		}

		@Override
		public void warn(String message) {
			if (this.logger.isLoggable(Level.WARNING)) {
				this.logger.log(Level.WARNING, message);
			}
		}

		@Override
		public void error(String message) {
			if (this.logger.isLoggable(Level.SEVERE)) {
				this.logger.log(Level.SEVERE, message);
			}
		}

		@Override
		public void error(String message, Throwable exception) {
			if (this.logger.isLoggable(Level.SEVERE)) {
				this.logger.log(Level.SEVERE, message, exception);
			}
		}
	}
}
