// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.jwt;

import java.util.regex.Pattern;

import com.appslandia.common.utils.AssertUtils;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class JwtUtils {

	public static final String TYP_JWT = "JWT";

	public static final String ALG_HS256 = "HS256";
	public static final String ALG_HS384 = "HS384";
	public static final String ALG_HS512 = "HS512";

	public static final String ALG_RS256 = "RS256";
	public static final String ALG_RS384 = "RS384";
	public static final String ALG_RS512 = "RS512";

	public static final String ALG_ES256 = "ES256";
	public static final String ALG_ES384 = "ES384";
	public static final String ALG_ES512 = "ES512";

	public static final String JWT_PART_SEP = ".";
	private static final Pattern JWT_PART_SEP_PATTERN = Pattern.compile("\\.");

	public static String[] parseParts(String jwt) {
		AssertUtils.assertNotNull(jwt);

		String[] parts = JWT_PART_SEP_PATTERN.split(jwt);
		if (parts.length != 3) {
			return null;
		}
		return parts;
	}
}
